// ===========================================================================
// $Source: d:/source/master/crusher/src/errors.h,v $
// $Revision: 1.13 $
// $Date: 1998/08/03 03:53:54 $
// ===========================================================================
// Copyright (C) 1998 Tom Conder <blitz@gazpacho.net>. All Rights Reserved.
//
// BY USING ANY PORTION OF THIS SOFTWARE, YOU AGREE TO THE FOLLOWING
// TERMS AND CONDITIONS:
// 
// Tom Conder, "THE AUTHOR", grants you, "THE USER", a non-exclusive,
// royalty free, license to use this software in source and binary code
// form, provided the user does not utilize the software in a manner
// which is disparaging to the author and the user acknowledges the
// author in any derivative work.
// 
// This software is provided "AS IS," without a warranty of any kind. ALL
// EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING
// ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. THE AUTHOR SHALL NOT
// BE LIABLE FOR ANY DAMAGES SUFFERED BY THE USER AS A RESULT OF USING,
// MODIFYING OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT
// WILL THE AUTHOR BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR
// DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE
// DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY,
// ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE, EVEN IF THE
// AUTHOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
// ===========================================================================
// Project:    Crusher md2 viewer
//
// File:       errors.h
//
// Written:    16 Jun. 1998 - Tom Conder <blitz@gazpacho.net>
//
// Description:
//    This header file contains error code definition used throughout the
//    program.
//
// Modifications:
// $Log$
// ===========================================================================
#ifndef __ERRORS_H
#define __ERRORS_H

#define RC_OK				TRUE

// ========================================================================
// Generic Errors
// ========================================================================
#define ERR_GENERIC_BASE		2

// Generic memory allocation error
#define ERR_GENERIC_ALLOC		ERR_GENERIC_BASE + 1

// ========================================================================
// Render Errors
// ========================================================================
#define ERR_RENDER_BASE			64

// Unable to get device context
#define ERR_RENDER_DC			ERR_RENDER_BASE + 1

// Unable to create compatible device context
#define ERR_RENDER_COMPAT_DC	ERR_RENDER_BASE + 2

// Unable to select bitmap
#define ERR_RENDER_BITMAP		ERR_RENDER_BASE + 3

// Unable to realize palette
#define ERR_RENDER_REALIZE		ERR_RENDER_BASE + 4

// Unable to create DIBSection
#define ERR_RENDER_DIBSECTION	ERR_RENDER_BASE + 5

// Unable to allocate memory for the bitmap
#define ERR_RENDER_ALLOC_DIB	ERR_RENDER_BASE + 6

// Unable to allocate memory for the palette
#define ERR_RENDER_ALLOC_PAL	ERR_RENDER_BASE + 7

// No path in registry
#define ERR_RENDER_REG			ERR_RENDER_BASE + 8

// Unable to find first file
#define ERR_RENDER_FIND_FIRST	ERR_RENDER_BASE + 9

// Invalid texture path
#define ERR_RENDER_TEX_PATH		ERR_RENDER_BASE + 10

// Unable to select palette
#define ERR_RENDER_PAL_SEL		ERR_RENDER_BASE + 11

// Unable to create palette
#define ERR_RENDER_PAL_CREATE	ERR_RENDER_BASE + 12

// Unable to realize palette
#define ERR_RENDER_PAL_REALIZE	ERR_RENDER_BASE + 13

// Unable to open registry entry
#define ERR_RENDER_REG_OPEN		ERR_RENDER_BASE + 14

// Unable to query registry entry
#define ERR_RENDER_REG_QUERY	ERR_RENDER_BASE + 15

// ========================================================================
// MD2 Errors
// ========================================================================
#define ERR_MD2_BASE			128

// Error allocating frame info
#define ERR_MD2_FRAMELIST		ERR_MD2_BASE + 1

// Error allocating gl cmds
#define ERR_MD2_GLCMDS			ERR_MD2_BASE + 2

// Unable to open file for reading
#define ERR_MD2_INVALIDMODEL	ERR_MD2_BASE + 3

// Unable to open file for reading
#define ERR_MD2_OPENFILE		ERR_MD2_BASE + 4

// Error allocating points
#define ERR_MD2_POINTS			ERR_MD2_BASE + 5

// Error allocating triangles
#define ERR_MD2_TRIS			ERR_MD2_BASE + 6

// Error allocating memory for texture coordinates
#define ERR_MD2_ST				ERR_MD2_BASE + 7

// Invalid md2 header
#define ERR_MD2_IDENT			ERR_MD2_BASE + 8

// Invalid texture height
#define ERR_MD2_TEXHEIGHT		ERR_MD2_BASE + 9

// Invalid texture width
#define ERR_MD2_TEXWIDTH		ERR_MD2_BASE + 10

// ========================================================================
// PCX Errors
// ========================================================================
#define ERR_PCX_BASE			192

// Not a valid device context
#define ERR_PCX_DC				ERR_PCX_BASE + 1

// Unable to open file for reading
#define ERR_PCX_OPENFILE		ERR_PCX_BASE + 2

// Not a valid PCX file
#define ERR_PCX_IDENTIFIER		ERR_PCX_BASE + 3

// Invalid PCX Header
#define ERR_PCX_HEADER			ERR_PCX_BASE + 4

// Must be an 8 bit PCX file
#define ERR_PCX_EIGHTBIT		ERR_PCX_BASE + 5

// Invalid PCX version number
#define ERR_PCX_VERSION			ERR_PCX_BASE + 6

// Invalid palette
#define ERR_PCX_PALETTE			ERR_PCX_BASE + 7

// Unable to allocate memory for pixel array
#define ERR_PCX_PIXEL_ARRAY		ERR_PCX_BASE + 8

// Unable to allocate memory for bitmap
#define ERR_PCX_BITMAP			ERR_PCX_BASE + 9


// prototypes
void DisplayErrorMessage (UINT);

#endif // __ERRORS_H
