// ===========================================================================
// $Source: d:/source/master/crusher/src/defs.h,v $
// $Revision: 1.13 $
// $Date: 1998/08/03 04:54:10 $
// ===========================================================================
// Copyright (C) 1998 Tom Conder <blitz@gazpacho.net>. All Rights Reserved.
//
// BY USING ANY PORTION OF THIS SOFTWARE, YOU AGREE TO THE FOLLOWING
// TERMS AND CONDITIONS:
// 
// Tom Conder, "THE AUTHOR", grants you, "THE USER", a non-exclusive,
// royalty free, license to use this software in source and binary code
// form, provided the user does not utilize the software in a manner
// which is disparaging to the author and the user acknowledges the
// author in any derivative work.
// 
// This software is provided "AS IS," without a warranty of any kind. ALL
// EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING
// ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. THE AUTHOR SHALL NOT
// BE LIABLE FOR ANY DAMAGES SUFFERED BY THE USER AS A RESULT OF USING,
// MODIFYING OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT
// WILL THE AUTHOR BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR
// DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE
// DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY,
// ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE, EVEN IF THE
// AUTHOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
// ===========================================================================
// Project:    Crusher md2 viewer
//
// File:       defs.h
//
// Written:    16 Jun. 1998 - Tom Conder <blitz@gazpacho.net>
//
// Description:
//    This header file contains some basic structures used throughout all
//    program modules.
//
// Modifications:
// $Log$
// ===========================================================================
#ifndef __DEFS_H
#define __DEFS_H

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#define	iWIDTH					512
#define	iHEIGHT					384

#define	iMAX_PATH_LEN			512

#define iREG_KEY_BUF_SIZE		256

#define	iWIREFRAME_TRI_COLOR	215

#define tDEFAULT				"(default)"

#define tQUAKE2_PATH			"C:\\Quake2\\"
#define	tQUAKE2_PLAYER_DIR		"baseq2\\players\\"
#define tQUAKE2_MD2_PATHNAME	"female"
#define	tQUAKE2_MD2_FILENAME	"tris.md2"
#define tQUAKE2_PCX_FILENAME	"jezebel.pcx"

#define tREG_KEY_CLASS			"Software\\Gazpacho"
#define tREG_KEY_NAME			"Crusher"
#define tREG_KEY_CRUSHER		"Software\\Gazpacho\\Crusher"
#define tREG_KEY_Q2PATH			"Quake2Path"
#define tREG_KEY_PATH			"LastPath"
#define tREG_KEY_MODEL			"LastModel"
#define tREG_KEY_SKIN			"LastSkin"

typedef POINT POINT_2D;

typedef struct
{
   double x, y, z;
}   POINT_3D;

typedef float vec_t;
typedef vec_t vec3_t[3];

typedef struct
{
	POINT_3D *tris;
} framelist_t;

typedef struct
{
	LONG x, y;
	short s, t;
} triangle_t;

#endif // __DEFS_H
