// .SWL -> .PCX Converter by Clayten Hamacher (WhiteNight) 
// Used to convert SiN textures to PCX files
// Based off of source for Trey Harrison's PCX2WAL program for Q2.
// wnight@rocketmail.com
// whitenight@home.com <- primary
// Trey no longer works for Crack.com (and Crack.com sadly no-longer exists.)
// so you'll have to find your own way to contact him.

#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>

const int HeaderLength = 1236; // It might change, ya never know.

char RGBApal[256][4];

void remove_extention(char *string);
void write_pcx(char *base_name,unsigned char *mip, int width,int height);

int main(int argc, char *argv[])
{
  	FILE *f;

	char	fname[1025];
  	char 	swlname[64];
  	long  mip_offset, junk;
  	long  width, height;
//  	int  	mipsize;
	long	length, expected_length;

	long	mipsize;

  	unsigned char *mip = 0;


  	if (argc<2)
  	{
    	fprintf(stderr,"Must specify the .SWL file\n");
		fprintf(stderr,"swl2pcx <filename.swl>\n");
    	exit(-1);
  	}

	strncpy(fname,argv[1],1024);
	fname[1024] = 0;

	f = fopen(fname,"rb");
   if (!f)
   {
   	printf("Couldnt open file: %s\n",fname);
      exit(-1);
	}

   fseek(f,0,SEEK_END);
   length = ftell(f);
   fseek(f,0,SEEK_SET);

	fread(swlname,64,1,f);

	printf("Converting %s to ",fname);
   remove_extention(fname); // Try to strip trailing .swl extension
	printf("%s.pcx\n",fname);

   fread(&width,1,sizeof(long),f);
   fread(&height,1,sizeof(long),f);

	fread(&RGBApal,1,sizeof(RGBApal),f); // 1024 bytes, RGBA pallette

   fread(&junk,1,sizeof(long),f); // The pallette CRC
   fread(&mip_offset,1,sizeof(long),f); // Offset of primary mip

   mipsize = width*height;
    
	expected_length = mipsize + (mipsize / 4) + (mipsize / 16) + (mipsize / 64) + HeaderLength;

	if (length != expected_length) { // Check to make sure the file is valid

	  	fprintf(stderr,"invalid .SWL file: %s\n",argv[1]);

	} else {

		printf("Texture name: %s\n",swlname);
  
	   mip = malloc(mipsize);

	   fseek(f,mip_offset,SEEK_SET);
	   fread(mip,mipsize,1,f);
	   write_pcx(fname,mip,width,height);
	}

   fclose(f);

  	return 0;
}

void remove_extention(char *name)
// If the string is longer than five characters (the minimum, n.eee = 5)
// then search for the end. If the last three characters are "swl" then
// remove them, and the period. If they are not, do nothing. Likewise, if
// the filename is less than five characters (ie, we'd be clobbering
// something before the buffer by going back four characters) then do nothing.
{
  	char *p;

	p = name;

  	while (*p) {
		p++;
  	}

	if ((p - name) >= 5) {
   	if (!strnicmp("swl",(p - 3),3)) {
			p[-4] = 0;
		}
  	}
}

void write_pcx(char *base_name,unsigned char *mip, int width,int height)
{
  	long	i,j;
  	short w,h,bytesperline;
  	char 	fname[1028];
  	char 	RGBpal[256][3];

  	FILE *f=0;

	strncpy(fname,base_name,1024);
  	strcat(fname,".pcx");

  	f = fopen(fname,"wb");
  	if (!f) {
    	printf("Invalid destination .PCX filename, %s\n",fname);
    	return;
  	}

  	printf("Writing .PCX file -> %s\n",fname);

  	w = width-1;
  	h = height-1;
  	bytesperline = width;

  	//hardcoded 8 bit uncompressed .pcx writer
  	fputc(0x0A,f); // PCX ID
  	fputc(0x05,f); // Version 3.0
  	fputc(0x01,f); // PCX RLE Encoding
  	fputc(0x08,f); // Bits per pixel

  	fputc(0x00,f); // Min X and Y
  	fputc(0x00,f);
  	fputc(0x00,f);
  	fputc(0x00,f);
	
  	fwrite(&w,sizeof(short),1,f); // Max X and Y
  	fwrite(&h,sizeof(short),1,f);

  	fputc(0x00,f); // Resolution or something. Dunno if it's needed.
  	fputc(0x96,f);
  	fputc(0x00,f);
  	fputc(0x96,f);

  	for(i=0; i<48; i++) { // EGA pallette (blank)
    	fputc(0x00,f);
	}

  	fputc(0x00,f); // Reserved
  	fputc(0x01,f); // Number of color plans
  	fwrite(&bytesperline,sizeof(short),1,f); // Bytes per line
  	fputc(0x02,f); // This looks like it should be grayscale, but it works...

  	for(i=0; i<59; i++) {
    	fputc(0x00,f); // Reserved filler
	}

  	for(i=0; i<height; i++) {
    	for(j=0; j<width; j++) {
	      fputc(0xC1,f);					// repeat next byte 1 time
   	   fputc(mip[i*width+j],f);
    	}
  	}

  	fputc(12,f); // 256 color VGA pallette
	
  	//write the palette
  	for (j = 0;j < 256;j++) {
	  	for (i = 0;i < 3;i++) {
		  	RGBpal[j][i] = RGBApal[j][i];
		}
   }
  	fwrite(RGBpal,768,1,f); // 768 byte pallette

  	fclose(f);
}
