unit QRunAPI;
{------------------------------------------------------------------------------}
interface

uses
	Windows;
{------------------------------------------------------------------------------}
const
	// Version Number of API used
	v1_30 = $0000011e;

	// Icon-sizes
	IS_16X16 = 1;
	IS_32X32 = 2;
	IS_48X48 = 3;

type
	TAllowList = record
		// This record tells QRun32 to hide some of his options. Use this if your
		// plugin has own routines for these options.
		// e.g.: if you have an own routine to set the deathmatch-mode and you
		//       don't want the deathmatch-var to be changeable from within QRun32
		//       anymore, set "alDeathmatch" to "False".
		alMap,                  // allow map-selecting
		alPatch,                // allow patch-selecting
		alSkill,                // allow skill-selecting
		alDemoPlay,             // allow demo-playback
		alDemoRec,              // allow demo-recording
		alSetUpServer,          // allow setting up a server
		alConnectToServer,      // allow connecting to server
		alTimeLimit,            // allow setting of time-limit
		alFragLimit,            // allow setting of frag-limit
		alDeathmatch,           // allow changing deathmatch/coop-modes
		alTeamplay,             // allow changing teamplay-modes
		alNoExit,               // allow setting of "noexit"
		alPausable: Boolean;    // allow setting of "pausable"
	end;
{------------------------------------------------------------------------------}
	PSettings = ^TSettings;        // you get such a record for settings-info
	TSettings = packed record
	// misc settings
		Map            : PChar;    // the selected map
		Patch          : PChar;    // the selected patch
		Skill          : Byte;     // skill-level 0 to 3
		DemoState      : Byte;     // look at the "DS_"-constants for info....
		DemoName       : PChar;    // the demo-filename relative to the Quake-dir
		NoAutoAim      : Boolean;  // auto-aiming enabled ?
	// server-settings
		ServerEnabled  : Boolean;  // this machine acting as a server ?
		HostName       : PChar;    // the name of your server
		ConnectToServer: Boolean;  // this machine connects to a server ?
		ServerName     : PChar;    // ...to which server ?
		ServerType     : Byte;     // look at the "ST_"-constants for info....
		MaxPlayers     : Byte;     // max # of players allowed on this server
	// server-rules
		EnableFragLimit: Boolean;  // frag-limit enabled on this server ?
		FragLimit      : Byte;     // ...frag-limit set to how many frags ?
		EnableTimeLimit: Boolean;  // time-limit enabled on this server ?
		TimeLimit      : Byte;     // ...time-limit set to how many minutes ?
		Deathmatch     : Byte;     // look at the "DM_"-constants for info....
		Teamplay       : Byte;     // look at the "TP_"-constants for info....
		NoExit         : Boolean;  // "NoExit" enabled for this server ?
		Pausable       : Boolean;  // clients may pause the game ?
	// global settings
		QuakePath      : PChar;    // the directory where Quake resides
		PatchPath      : PChar;    // the subdir where all the patches are located
	// general options
		CommandLineMode: Byte;     // look at the "CM_"-constants for info....
		CFGFile        : PChar;    // save params to this file
	// Sound-settings
		SampleRate     : Word;     // sample-rate up to 44100 Hz
		CDMediaCheck   : Boolean;  // checks periodically, if CD was changed
	// Network-settings
		NoUDP          : Boolean;  // no TCP/IP-support
		NoIPX          : Boolean;  // no IPX-support
		NoSerial       : Boolean;  // no serial-support
		IPXPort        : Word;     // alternative IPX-port
		UDPPort        : Word;     // alternative TCP/IP-port
	// Win95 memory-settings
		WinMem         : Byte;     // how many MB does Quake allocate
		LockMethod     : Byte;     // look at the "LM_"-constants for info....
	// Troubleshooting-settings
		SafeMode       : Boolean;  // disables all of the following...
		NoVESA         : Boolean;  // disables VESA 2.0 - support
		NoNetwork      : Boolean;  // no multiplayer-support
		NoSound        : Boolean;  // disables ALL sound in Quake
		NoCDAudio      : Boolean;  // should CD-audio be used ?
		NoJoy          : Boolean;  // disable Joystick-usage
	end;
{------------------------------------------------------------------------------}
const
	strNone = '<none>'; // edit-controls use this string when they have no
	//                     important content.

	// the following constants are for the TSettings record.

	CM_CMDLINE     = 0; // params will be directly written to the commandline
	CM_CFGFILE     = 1; // params will be saved to a config-file and then
	//                     executed with "+exec <file>"

	LM_NONE        = 0; // Quake doesn't lock itself in memory
	LM_WINLOCK     = 1; // Quake locks itself in mem
	LM_LOCKUNLOCK  = 2; // Quake uses an alternative locking mechanism
	LM_HSAUTOMATIC = 3; // WinQuake automatic HeapSize
	LM_HSOVERRIDE  = 4; // Overrides WinQuake HeapSize

	DS_NOTHING     = 0; // neither playing nor recording a demo
	DS_PLAYING     = 1; // playback a demo
	DS_RECORDING   = 2; // record a demo

	ST_LISTEN      = 0; // set up a listen-server
	ST_DEDICATED   = 1; // set up a dedicated-server

	DM_COOP        = 0; // play cooperative
	DM_DEATHMATCH1 = 1; // play with respawning weapons & items
	DM_DEATHMATCH2 = 2; // play with staying weapons

	TP_NONE        = 0; // no teamplay
	TP_TEAMPLAY1   = 1; // teammates are immune against your weapons
	TP_TEAMPLAY2   = 2; // you kill a teammate -> get a negative frag!

// the next constants have to be passed to "QRUN_GetInfo" to communicate
// with QRun32.
// these actions return a "PChar" or "nil" if the user aborts the action.

	GI_SELECTMAP      = 0;     // lets the user select a user-created map
	// GI_SELECTPATCHMAP is now obsolete !

	GI_SELECTPATCH    = 2;     // lets the user select a patch
	GI_SELECTDEMO     = 3;     // lets the user select a demo
	GI_SELECTPATCHDEMO= 8;     // lets the user select a demo located in the
	//                            patch-dir

	// GI_SELECTQUAKEEXE, GI_SELECTQUAKEBAT and GI_SELECTWINDED are now obsolete
	// Only QRun32 now allows you to select the executable

	GI_GETRELPATCHDIR = 7;     // gets the patch-dir relative to the Quake-dir

var
	QRUN_GetInfo: function(What:Word):Pointer;
		// Function used to gather information from QRun32.
		// Parameters:
		//   What  -  One of the above defined "GI_"-constants.
		//
		// This function results a pointer to the information you queried. In most
		// cases this will be a PChar.

function StrNotEmpty(S: string):Boolean;
	// this function checks, if a string isn't empty and not "strNone".
{------------------------------------------------------------------------------}
implementation
{------------------------------------------------------------------------------}
function StrNotEmpty(S: string):Boolean;
begin
	result := (S<>'') and (S<>strNone)
end;
{------------------------------------------------------------------------------}
end.
