library PlugIn;
{------------------------------------------------------------------------------}
uses
	Controls,
	Windows,
	SysUtils,
	Forms,
	QRunAPI in 'QRunAPI.pas',
	PlgInDlg in 'PlgInDlg.pas'; {PlugInDlg}

{$R *.RES}
{$R VERSION.RES}
{------------------------------------------------------------------------------}
var
	AL: TAllowList = (
		// This record tells QRun32 to hide some of his options. Use this if your
		// plugin has own routines for these options.
		// e.g.: if you have an own routine to set the deathmatch-mode and you
		//       don't want the deathmatch-var to be changeable from within QRun32
		//       anymore, set "alDeathmatch" to "False".
		// modify the values of this record for your needs !
		alMap            : True;  // allow map-selecting
		alPatch          : True;  // allow patch-selecting
		alSkill          : True;  // allow skill-selecting
		alDemoPlay       : True;  // allow demo-playback
		alDemoRec        : True;  // allow demo-recording
		alSetUpServer    : True;  // allow setting up a quake-server
		alConnectToServer: True;  // allow connecting to a quake-server
		alTimeLimit      : True;  // allow setting of time-limit
		alFragLimit      : True;  // allow setting of frag-limit
		alDeathmatch     : True;  // allow changing deathmatch/coop-modes
		alTeamplay       : True;  // allow changing teamplay-modes
		alNoExit         : True;  // allow setting of "noexit"
		alPausable       : True;  // allow setting of "pausable"
	);
{------------------------------------------------------------------------------}
{--- exported routines --------------------------------------------------------}
{------------------------------------------------------------------------------}
function PI_IsPlugIn:Boolean;export;
	// must NOT be changed. Used for recognition-purposes.
begin
	result := True;
end;
{------------------------------------------------------------------------------}
function PI_GetPlugInAPIVersion:DWORD;export;
	// please return your used API-version here
begin
	result := v1_30;
end;
{------------------------------------------------------------------------------}
procedure PI_SetInfoFn(GI_fn:Pointer);export;
	// After this proc is executed, your plug-in can communicate with QRun32
	// using the function "QRUN_GetInfo" and "QRUN_SetInfo" defined in "QRunAPI"
begin
	QRUN_GetInfo := GI_fn;    // do not remove this line
	// You can insert some initialization in here. At this point the user
	// selected your plug-in the first time, but he has not yet executed it.
	// This procedure is called just ONCE !
end;
{------------------------------------------------------------------------------}
function PI_GetDescription:PChar;export;
	// should return a short description (as PChar) of what this Plug-In does
begin
	result := '<put your description here>'
end;
{------------------------------------------------------------------------------}
function PI_GetIcon(Size:Integer):HIcon;export;
	// Should return a standard handle to an icon for displaying in QRun32.
	// "Size" is one of the "IS_"-constants defined in QRunAPI and tells you,
	// what type of icon QRun32 wants from you. You should return the correct
	// sized icon for proper view.
	// Delphi 2 allowed to return "Application.Icon.Handle", but Delphi 3 somehow
	// has problems with assigning an icon to a DLL, so you have to use a
	// workaround if you use Delphi 3.
	// Just try it and you'll see if it works.
begin
	result := Application.Icon.Handle;
end;
{------------------------------------------------------------------------------}
procedure PI_ExchangeSettings(Settings:PSettings);export;
	// When the plug-in is initialized, that means when the user selects your
	// plug-in, this proc is called. You should evaluate the "Settings" as needed
	// and write back your changes to the record, so that QRun32 can evaluate
	// it even at your plug-in startup.
begin
end;
{------------------------------------------------------------------------------}
function PI_Execute(Settings:PSettings):Boolean;export;
	// this procedure is called by QRun32, when a user executes your plug-in
	// In most cases, plug-ins present their main-window here.
	// NOTE: You'll get a record with information about all QRun32-settings.
	//       Use them to initialize your dialog! (Yes, do it again!)
	// If you want the user to be able to CANCEL your plug-in, you should
	// temporary save your own local settings. If the Dialog does not return
	// "mrOK", you should restore these local settings.
	// This function returns "TRUE" if the user selected "OK" (or something
	// similar) and "FALSE" if the user selected "CANCEL" (or something similar).
begin
	// Initialize your plug-in with the values from the "Settings"-record.

	// temorary save your local settings here

	result := PlugInDlg.ShowModal=mrOK;
	if result then begin
		// If succeeded, set your changed values to the "Settings"-record.
	end else begin
		// restore your local settings here
	end;
end;
{------------------------------------------------------------------------------}
function PI_QueryAllowList:Pointer;export;
	// this function should return an address of an TAllowList
	// in most cases this function need not be modified
begin
	result := @AL
end;
{------------------------------------------------------------------------------}
function PI_GetCommandLineParams(Settings:PSettings):PChar;
	// This function should return those parameters, that are added to the
	// Quake-starting commandline (e.g. '-game xyz' etc..)
	// You should place all the optional parameters your plug-in does into
	// this string without leading and trailing spaces.
	// When the string is returned, it will be eventually partial written to
	// a CFG-file depending on the "write parameters to"-setting in the QRun32-
	// options-tab. But don't bother about this...
begin
end;
{------------------------------------------------------------------------------}
procedure PI_SaveSettings(hk: HKEY);export;
	// This procedure is called, when QRun32 forces your PlugIn to save settings.
	// You get a handle to a previously (via "RegCreateKeyEx") opened registry-
	// key. There you can save whatever you want.
	// Do NOT close the handle when you are finished ! QRun32 does this.
begin
end;
{------------------------------------------------------------------------------}
procedure PI_RestoreSettings(hk: HKEY);export;
	// This procedure is called, when QRun32 forces your PlugIn to restore
	// settings.
	// You get a handle to a previously (via "RegOpenKeyEx") opened registry-
	// key. Your plug-in should find previously saved settings in here.
	// Do NOT close the handle when you are finished ! QRun32 does this.
begin
end;
{------------------------------------------------------------------------------}
exports
	// NOTE: It is not REALLY necessary to export all of these functions.
	//       QRun32 will install standard-dummy-functions, if a plug-in doesn't
	//       export it. However, you should fill some of the procs with life :)
	PI_IsPlugIn,          // ...but this one is REALLY needed  :)
	PI_GetPlugInAPIVersion,
	PI_SetInfoFn,
	PI_GetDescription,
	PI_GetIcon,
	PI_ExchangeSettings,
	PI_Execute,
	PI_QueryAllowList,
	PI_GetCommandLineParams,
	PI_SaveSettings,
	PI_RestoreSettings;
{------------------------------------------------------------------------------}
begin
	// put your initializations here (e.g. creation of windows, etc.)
	Application.CreateForm(TPlugInDlg, PlugInDlg);
end.
