unit CTF4Helpers;
{------------------------------------------------------------------------------}
interface

uses
	Windows, StdCtrls, QRunAPI, Main;

const
	Version = '2.0';

type
	TCTFSettings = record            // all the local CTF-settings
		Patch      : string;
		Teamplay   : Integer;
		Deathmatch : Byte;
		SysTicRate: string;
		TeamplaySig: string;
	end;

var
	GS: TCTFSettings = (             // GS = Global Settings
		Patch      : 'ctf';
		Teamplay   : 1955;
		Deathmatch : 1;
		SysTicRate: '0.1';
		TeamplaySig: '?CTF4';
	);

	Icon_small: HIcon = 0;
	Icon_large: HIcon = 0;
{------------------------------------------------------------------------------}
procedure ParseLocalSettings(LS: TCTFSettings);
	// Initializes the components with the values from the LS-record.

procedure EvalSettings(Settings:TSettings);
	// Evaluates a "Settings"-record by initializing the components.

procedure SetSettings(var Settings:TSettings);
	// Collects all information from the components and puts them to the
	// "Settings"-record, so that QRun32 may evaluate this information for itself.
{------------------------------------------------------------------------------}
implementation

uses
	SysUtils, Helpers;
{------------------------------------------------------------------------------}
procedure ParseLocalSettings(LS:TCTFSettings);
begin
	with MainDlg do begin
		edPatch.Text := LS.Patch;

		with cbHealth do Checked := (LS.Teamplay and Tag) <> 0;
		with cbArmor do Checked := (LS.Teamplay and Tag) <> 0;
		with cbAttackerDmg do Checked := (LS.Teamplay and Tag) <> 0;
		with cbFragPenalty do Checked := (LS.Teamplay and Tag) <> 0;
		with cbDeathPenalty do Checked := (LS.Teamplay and Tag) <> 0;
		with cbTeamColorLock do Checked := (LS.Teamplay and Tag) <> 0;
		with cbStaticTeams do Checked := (LS.Teamplay and Tag) <> 0;
		with cbDropItems do Checked := (LS.Teamplay and Tag) <> 0;
		with cbTeamSelect do Checked := (LS.Teamplay and Tag) <> 0;
		with cbCustomCTF do Checked := (LS.Teamplay and Tag) <> 0;
		with cbNoHook do Checked := (LS.Teamplay and Tag) <> 0;

		rbDM1.Checked := LS.Deathmatch = 1;
		rbDM2.Checked := LS.Deathmatch = 2;
		rbDM3.Checked := LS.Deathmatch = 3;

		SetComboText(comboTicRate, LS.SysTicRate);
		edTeamplaySig.Text := LS.TeamplaySig;
	end;
end;
{------------------------------------------------------------------------------}
procedure EvalSettings(Settings:TSettings);
begin
	with Settings do begin
		if StrNotEmpty(Patch) then MainDlg.edPatch.Text := Settings.Patch
		else MainDlg.edPatch.Text := 'ctf';
	end;
end;
{------------------------------------------------------------------------------}
procedure SetSettings(var Settings:TSettings);
begin
	with Settings do begin
		Patch := StrNew(PChar(GS.Patch));
		Teamplay := GS.TeamPlay;
		Deathmatch := GS.Deathmatch;
	end;
end;
{------------------------------------------------------------------------------}
begin
	Icon_large := LoadIcon(HInstance, 'ICON_LARGE');
	Icon_small := LoadIcon(HInstance, 'ICON_SMALL');
end.
