library ctf4;
{------------------------------------------------------------------------------}
uses
	Controls,
	Windows,
	SysUtils,
	Forms,
	Main in 'Main.pas' {MainDlg},
	QRunAPI in 'QRunAPI.pas',
	Helpers, RegistryHandling,
	CTF4Helpers;

{$R *.RES}
{$R ICON.RES}
{------------------------------------------------------------------------------}
var
	AL: TAllowList = (
		// modify the values of this record for your needs !
		alMap            : True;  // allow map-selecting
		alPatch          : False; // allow patch-selecting
		alSkill          : False; // allow skill-selecting
		alDemoPlay       : True;  // allow demo-playback
		alDemoRec        : True;  // allow demo-recording
		alSetUpServer    : True;  // allow setting up a quake-server
		alConnectToServer: True;  // allow connecting to a quake-server
		alTimeLimit      : True;  // allow setting of time-limit
		alFragLimit      : True;  // allow setting of frag-limit
		alDeathmatch     : False; // allow changing deathmatch/coop-modes
		alTeamplay       : False; // allow changing teamplay-modes
		alNoExit         : False; // allow setting of "noexit"
		alPausable       : True;  // allow setting of "pausable"
	);
{------------------------------------------------------------------------------}
{--- exported routines --------------------------------------------------------}
{------------------------------------------------------------------------------}
function PI_IsPlugIn:Boolean;export;
	// must NOT be changed. Used for recognition-purposes.
begin
	result := True;
end;
{------------------------------------------------------------------------------}
function PI_GetPlugInAPIVersion:DWORD;export;
	// please return your used API-version here
begin
	result := v1_30;
end;
{------------------------------------------------------------------------------}
procedure PI_SetInfoFn(GI_fn:Pointer);export;
	// After this proc is executed, your plug-in can communicate with QRun32
	// using the function "QRUN_GetInfo" and "QRUN_SetInfo" defined in "QRunAPI"
begin
	QRUN_GetInfo := GI_fn;    // do not remove this line
	// You can insert some initialization in here. At this point the user
	// selected your plug-in the first time, but he has not yet executed it.
	// This procedure is called just ONCE !
end;
{------------------------------------------------------------------------------}
function PI_GetDescription:PChar;export;
	// should return a short description (as PChar) of what this Plug-In does
begin
	result := 'Threewave Capture the Flag 4'
end;
{------------------------------------------------------------------------------}
function PI_GetIcon(Size:Integer):HIcon;export;
	// Should return a standard handle to an icon for displaying in QRun32.
	// "Size" is one of the "IS_"-constants defined in QRunAPI and tells you,
	// what type of icon QRun32 wants from you. You should return the correct
	// sized icon for proper view.
	// Delphi 2 allowed to return "Application.Icon.Handle", but Delphi 3 somehow
	// has problems with assigning an icon to a DLL, so you have to use a
	// workaround if you use Delphi 3.
	// Just try it and you'll see if it works.
begin
	case Size of
		IS_16X16: result := Icon_small;
		IS_32X32: result := Icon_large;
	end;
end;
{------------------------------------------------------------------------------}
procedure PI_ExchangeSettings(Settings:PSettings);export;
	// When the plug-in is initialized, that means when the user selects your
	// plug-in, this proc is called. You should evaluate the "Settings" as needed
	// and write back your changes to the record, so that QRun32 can evaluate
	// it even at your plug-in startup.
begin
	EvalSettings(Settings^);
	SetSettings(Settings^)
end;
{------------------------------------------------------------------------------}
function PI_Execute(Settings:PSettings):Boolean;export;
	// this procedure is called by QRun32, when a user executes your plug-in
	// In most cases, plug-ins present their main-window here.
	// NOTE: You'll get a record with information about all QRun32-settings.
	//       Use them to initialize your dialog! (Yes, do it again!)
	// If you want the user to be able to CANCEL your plug-in, you should
	// temporary save your own local settings. If the Dialog does not return
	// "mrOK", you should restore these local settings.
	// This function returns "TRUE" if the user selected "OK" (or something
	// similar) and "FALSE" if the user selected "CANCEL" (or something similar).
var
	TempSettings: TCTFSettings;
begin
	// Initialize your plug-in with the values from the "Settings"-record.
	EvalSettings(Settings^);
	MainDlg.panelServerOptions.Visible := Settings.ServerEnabled;
	// temorary save your local settings here
	TempSettings := GS;

	result := MainDlg.ShowModal=mrOK;
	if result then begin
		// If succeeded, set your changed values to the "Settings"-record.
		SetSettings(Settings^);
	end else begin
		// restore your local settings here
		ParseLocalSettings(TempSettings);
	end;
end;
{------------------------------------------------------------------------------}
function PI_QueryAllowList:Pointer;export;
	// this function should return an address of an TAllowList
	// in most cases this function need not be modified
begin
	result := @AL
end;
{------------------------------------------------------------------------------}
function PI_GetCommandLineParams(Settings:PSettings):PChar;
	// This function should return those parameters, that are added to the
	// Quake-starting commandline (e.g. '-game xyz' etc...)
	// You should place all the optional parameters your plug-in does into
	// this string without leading and trailing spaces.
	// When the string is returned, it will be eventually partial written to
	// a CFG-file depending on the "write parameters to"-setting in the QRun32-
	// options-tab. But don't bother about this...
var
	S: string;
begin
	EvalSettings(Settings^);
	if FileExists(Settings^.QuakePath+'\'+GS.Patch+'\autoexec.cfg') and
	(Application.MessageBox('I have found an "AUTOEXEC.CFG"-file in the CTF-directory. '+
	'If it contains "Capture the Flag"-options, Quake will be disturbed by this file. '+
	'The CTF-server-package contains such a file by default. '+
	'With this plug-in you don''t need an "AUTOEXEC.CFG" anymore. Shall I delete it ?',
	'CTF 4: AUTOEXEC.CFG found !', MB_ICONSTOP+MB_YESNO) = ID_YES) then
		DeleteFile(Settings^.QuakePath+'\'+GS.Patch+'\autoexec.cfg');
	S := '-game '+MainDlg.edPatch.Text;

	if Settings.ServerEnabled then begin
		if GS.SysTicRate<>'0.05' then S := S + ' +sys_ticrate ' + GS.SysTicRate;
		S := S + ' +teamplay ' + IntToStr(GS.Teamplay) + GS.TeamPlaySig;
		if GS.Deathmatch<>1 then S := S + ' +deathmatch ' + IntToStr(GS.Deathmatch);
	end;

	result := StrNew(PChar(S));
end;
{------------------------------------------------------------------------------}
procedure PI_SaveSettings(hk: HKEY);export;
	// This procedure is called, when QRun32 forces your PlugIn to save settings.
	// You get a handle to a previously (via "RegCreateKeyEx") opened registry-
	// key. There you can save whatever you want.
	// Do NOT close the handle when you are finished ! QRun32 does this.
begin
	with MainDlg do begin
		RegSaveString(hk, 'Version', Version);
		RegSaveString(hk, 'SysTicRate', GS.SysTicRate);
		RegSaveDWord(hk, 'CTF-Teamplay', GS.Teamplay);
		RegSaveString(hk, 'TeamplaySig', GS.TeamplaySig);
	end;
end;
{------------------------------------------------------------------------------}
procedure PI_RestoreSettings(hk: HKEY);export;
	// This procedure is called, when QRun32 forces your PlugIn to restore
	// settings.
	// You get a handle to a previously (via "RegOpenKeyEx") opened registry-
	// key. Your plug-in should find previously saved settings in here.
	// Do NOT close the handle when you are finished ! QRun32 does this.
begin
	with MainDlg do if RegReadString(hk, 'Version') = Version then begin
		GS.SysTicRate := RegReadString(hk, 'SysTicRate');
		GS.Teamplay := RegReadDWord(hk, 'CTF-Teamplay');
		GS.TeamplaySig := RegReadString(hk, 'TeamplaySig');
		ParseLocalSettings(GS);
	end;
end;
{------------------------------------------------------------------------------}
exports
	// NOTE: It is not REALLY necessary to export all of these functions.
	//       QRun32 will install standard-dummy-functions, if a plug-in doesn't
	//       export it. However, you should fill some of the procs with life :)
	PI_IsPlugIn,          // ...but this one is REALLY needed  :)
	PI_GetPlugInAPIVersion,
	PI_SetInfoFn,
	PI_GetDescription,
	PI_GetIcon,
	PI_ExchangeSettings,
	PI_Execute,
	PI_QueryAllowList,
	PI_GetCommandLineParams,
	PI_SaveSettings,
	PI_RestoreSettings;
{------------------------------------------------------------------------------}
begin
	// put your initializations here (e.g. creation of windows, etc.)
//	MainDlg := TMainDlg.Create(Application);
	Application.CreateForm(TMainDlg, MainDlg);
end.
