unit RegistryHandling;

interface

uses
	SysUtils, Windows, Classes;

procedure RegSaveString(hk:HKEY; S1, S2:string);
procedure RegSaveBool(hk:HKEY; S1:string; B:Boolean);
procedure RegSaveDWord(hk:HKEY; S1:string; const X:DWORD);
procedure RegSaveStringList(hk:HKEY; SL:TStrings);
function RegReadString(hk:HKEY; S1:string):string;
function RegReadBool(hk:HKEY; S1:string):Boolean;
function RegReadDWord(hk:HKEY; S1:string):DWord;
procedure RegReadStringList(hk:HKEY; SL:TStrings; NoDoubles:Boolean; Limit:Integer);


implementation
{------------------------------------------------------------------------------}
procedure RegSaveString(hk:HKEY; S1, S2:string);
begin
	RegSetValueEx(hk, PChar(S1), 0, REG_SZ, PChar(S2), Length(S2));
end;
{------------------------------------------------------------------------------}
procedure RegSaveBool(hk:HKEY; S1:string; B:Boolean);
var
	S : string;
begin
	if B then S := 'Yes'
	else S := 'No';
	RegSetValueEx(hk, PChar(S1), 0, REG_SZ, PChar(S), Length(S));
end;
{------------------------------------------------------------------------------}
procedure RegSaveDWord(hk:HKEY; S1:string; const X:DWORD);
begin
	RegSetValueEx(hk, PChar(S1), 0, REG_DWORD, @X, SizeOf(DWORD));
end;
{------------------------------------------------------------------------------}
procedure RegSaveStringList(hk:HKEY; SL:TStrings);
var
	i : Integer;
begin
	RegSaveString(hk, 'Count', IntToStr(SL.Count));
	for i:=1 to SL.Count do
		RegSaveString(hk, IntToStr(i), SL.Strings[i-1]);
end;
{------------------------------------------------------------------------------}
function RegReadString(hk:HKEY; S1:string):string;
var
	PStr : PChar;
	datasize : DWORD;
begin
	PStr := StrAlloc(MAX_PATH+1);
	datasize := MAX_PATH+1;
	if RegQueryValueEx(hk, PChar(S1), NIL, NIL, Pointer(PStr), @datasize)=ERROR_SUCCESS then
		RegReadString := StrPas(PStr)
	else
		RegReadString := '';
	StrDispose(PStr);
end;
{------------------------------------------------------------------------------}
function RegReadBool(hk:HKEY; S1:string):Boolean;
var
	PStr : PChar;
	datasize : DWORD;
begin
	PStr := StrAlloc(MAX_PATH+1);
	datasize := MAX_PATH+1;
	if RegQueryValueEx(hk, PChar(S1), NIL, NIL, Pointer(PStr), @datasize)=ERROR_SUCCESS then
		if PStr='Yes' then RegReadBool := True
		else RegReadBool := False
	else RegReadBool := False;
	StrDispose(PStr);
end;
{------------------------------------------------------------------------------}
function RegReadDWord(hk:HKEY; S1:string):DWord;
var
	X : DWORD;
	datasize : DWORD;
begin
	X := -1;
	datasize := SizeOf(DWORD);
	RegQueryValueEx(hk, PChar(S1), NIL, NIL, @X, @datasize);
	RegReadDWord := X;
end;
{------------------------------------------------------------------------------}
procedure RegReadStringList(hk:HKEY; SL:TStrings; NoDoubles:Boolean; Limit:Integer);
var
	i, j : Integer;
	S : string;
begin
	j := StrToInt(RegReadString(hk, 'Count'));
	if (Limit=0) or (Limit>j) then Limit := j;
	for i:=1 to Limit do begin
		S := RegReadString(hk, IntToStr(i));
		if (S<>'') and (not NoDoubles or (NoDoubles and (SL.IndexOf(S)=-1))) then
			SL.Add(S);
	end;
end;
{------------------------------------------------------------------------------}
end.
