unit Main;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls, MPlayer, Buttons, ExtCtrls, ComCtrls;

type
	TMainDlg = class(TForm)
		imgLogo: TImage;
		panelClient: TPanel;
		Label9: TLabel;
		edPatch: TEdit;
    buOK: TButton;
		buCancel: TButton;
		panelServer: TPanel;
    panelServerOptions: TPanel;
    grpServerFlags: TGroupBox;
    grpProtection: TGroupBox;
    cbHealth: TCheckBox;
    cbArmor: TCheckBox;
    grpPenalties: TGroupBox;
    cbAttackerDmg: TCheckBox;
    cbFragPenalty: TCheckBox;
    cbDeathPenalty: TCheckBox;
    grpCTFSettings: TGroupBox;
    cbCustomCTF: TCheckBox;
    grpGameplay: TGroupBox;
    cbTeamColorLock: TCheckBox;
		cbStaticTeams: TCheckBox;
    cbDropItems: TCheckBox;
    cbTeamSelect: TCheckBox;
		grpMisc: TGroupBox;
    Label1: TLabel;
    Label10: TLabel;
    comboTicRate: TComboBox;
		edTeamplaySig: TEdit;
    labNoServer: TLabel;
    groupDeathmatch: TGroupBox;
    rbDM1: TRadioButton;
    rbDM2: TRadioButton;
    rbDM3: TRadioButton;
    labVersion: TLabel;
    SpeedButton1: TSpeedButton;
    cbNoHook: TCheckBox;
		procedure FormCreate(Sender: TObject);
		procedure cbTeamplayChange(Sender: TObject);
		procedure rbDeathmatchChange(Sender: TObject);
		procedure edPatchChange(Sender: TObject);
		procedure comboTicRateChange(Sender: TObject);
		procedure edTeamplaySigChange(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	MainDlg: TMainDlg;

implementation

uses
	QRunAPI, Helpers, CTF4Helpers;

{$R *.DFM}

procedure TMainDlg.FormCreate(Sender: TObject);
begin
	imgLogo.Picture.Icon.Handle := Icon_Large;
	MainDlg.Icon.Handle := Icon_Small;
	labVersion.Caption := 'Version '+Version;
end;

procedure TMainDlg.cbTeamplayChange(Sender: TObject);
begin
	with Sender as TCheckBox do
		if Checked then GS.TeamPlay := GS.Teamplay or Tag
		else GS.TeamPlay := GS.Teamplay and not Tag;
end;

procedure TMainDlg.rbDeathmatchChange(Sender: TObject);
begin
	GS.Deathmatch := (Sender as TRadioButton).Tag;
end;

procedure TMainDlg.edPatchChange(Sender: TObject);
begin
	GS.Patch := edPatch.Text;
end;

procedure TMainDlg.comboTicRateChange(Sender: TObject);
begin
	GS.SysTicRate := comboTicRate.Text;
end;

procedure TMainDlg.edTeamplaySigChange(Sender: TObject);
begin
	GS.TeamplaySig := edTeamplaySig.Text;
end;

procedure TMainDlg.SpeedButton1Click(Sender: TObject);
var
	P: PChar;
begin
	P := QRUN_GetInfo(GI_SELECTPATCH);
	if P<>nil then edPatch.Text := P;
end;

end.
