/*
  wreckdum quake unpacker for linux.

  usage:
           wreckdum [<pakfile>] [<outdir>]
           <pakfile> default is "id1.pak"
           <outdir> default is "<pakfile>.out"
*/
        
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/stat.h>
#include <stdlib.h>

#define kMaxDirEntries 500
#define kBufferSize    10000

int write_rec(int i);
void usage();
int makepath( char *fname );

typedef struct
{
  char name[56];
  unsigned long offset, length;
} dirrec;

dirrec dir[kMaxDirEntries];
char buf[kBufferSize];
FILE *in;

unsigned long dir_start, num_ents;

int main(int argc, char *argv[])
{
/*  long l;*/
  int i;
/* i1, i2, i3, i4;*/
  char infile[80];
  char outdir[80];
  char signature[5];;

  if(argc >= 2)
    strcpy(infile, argv[1]);
  else
  {
    strcpy(infile, "id1.pak");
    strcpy(outdir, "id1.pak.out");
    fprintf(stderr, "No args, using input=%s and output=%s/.\n", infile, outdir);
  }
  if(argc >= 3)
    strcpy(outdir, argv[2]);
  else
  {
    strcpy(outdir, infile);
    strcat(outdir, ".out");
  }

  in=fopen(infile,"rb");
  if (!in)
  {
    printf("Error opening \"%s\"", infile);
    return 1;
  }

  if( mkdir(outdir, 493 /*octal=755*/) == -1 )
  {
    perror( "Error" );
    fclose(in);
    return 1;
  }
  else
  {
    chdir(outdir);
  }

  fread((void *)signature, 4, 1, in);
  signature[4] = '\0';
  if(strcmp(signature, "PACK"))
  {
    fprintf(stderr, "Error: Not a PACK file.\n");
    fclose(in);
    return 1;
  }

  fread((void *)&dir_start, 4, 1, in);
  fread((void *)&num_ents, 4, 1, in);
  num_ents/=sizeof(dirrec);
  fseek(in,dir_start,SEEK_SET);

  if (num_ents>=kMaxDirEntries)
  {
    fprintf(stderr, "Error: Too many entries!\n");
    fclose(in);
    return 1;
  }

  fread((void *)dir, sizeof(dirrec), num_ents, in);

  for(i = 0; i < num_ents; i++)
  {
    printf("%d: \"%s\"\n",i,dir[i].name);
    if(write_rec(i))
      perror("write_rec Error");
  }
  
  fclose(in);
  return 0;
}

int write_rec(int i)
{
  FILE *f = 0;
  long l;
  int blocks;
  int count;
  int s;

  makepath(dir[i].name);

  f=fopen(dir[i].name,"wb");
  if (!f)
  {
    printf("Error opening \"%s\"!\n",dir[i].name);
    return 1;
  }
  fseek(in,dir[i].offset,SEEK_SET);
  blocks=dir[i].length/(kBufferSize-1);
  if (dir[i].length%(kBufferSize-1))
    blocks++;
  for (count=0;count<blocks;count++)
  {
    fread((void *)buf,1,(kBufferSize-1),in);
    l=dir[i].length - (long)count * (kBufferSize-1);
    if (l>(kBufferSize-1))
      l=(kBufferSize-1);
    s=l;
    fwrite((void *)buf,1,s,f);
  }
  fclose(f);
  return 0;
}

int makepath( char *fname )
/* given "some/path/to/file", makes all dirs (ie "some/", "some/path/", */
/* and "some/path/to/", so that file can be created                     */
{
  char *c = fname;
  char *o = (char *)malloc(strlen(fname)+1);
  char *n = o;

  while( *c )
  {
    while( *c != '/' && *c )
      *n++ = *c++;

    if( *c )
    {
      *n = '\0';
      mkdir( o, 493 /*octal=755*/ );
      *n = '/';
      n++;
      c++;
    }
  }
  free(o);
  return 0;
}
