/***
****  QuBE --- Vertex manipulation routines.
***/

#include "qube.h"
#include "vertex.h"

/*
**  VertexList.  Dumps out the vertices in a BSP file.
*/

void VertexList(void)
{
	short int i, j, k;
	unsigned long readcount;
	vertex v;

	if (header.id != 0x17)
		Error("Not a valid .BSP file");

	fseek(fi, header.vertices, SEEK_SET);

	for (i = 0, readcount = 0L; readcount < header.verticeslen; readcount += 12, i++) {
		fread((char *)&v, 1, 12, fi);
		printf("%4d:  %10.2f %10.2f %10.2f \n", i, v.x, v.y, v.z);
        }
}


