/***
****  QuBE --- Entity manipulation routines.
***/

/* These are the parts of a entity.  Note that "origin" and the coords
   are redundant, but I haven't had the chance to take them out yet. */

typedef struct {
	char *classname;
	char *origin;
        char *angle;
	char *style;
	char *spawnflags;
	char *wad;
	char *light;
	char *model;
	long int x, y, z;
	int type;
} entity;

/* Thing data.	Needed by gfx.c */

extern entity *entityarray[2048];
extern int nextentity;
extern int curentity;
extern int putback;
extern long int maxlen;

enum {
	ENTITY_NONE = 0,
	ENTITY_WEAPON,
	ENTITY_MONSTER,
	ENTITY_HEALTH,
	ENTITY_ITEM,
	ENTITY_LIGHT,
	ENTITY_VISILIGHT,
	ENTITY_START,
	ENTITY_DMSTART,
};

/* Thing parse routines.  Needed by gfx.c */

void skipspace(FILE *fp);
int nextchar(FILE *fp);
int fileend(void);
char *getstring(FILE *fp);
int getopenbrace(FILE *fp);
int getclosebrace(FILE *fp);
void EntList(void);
void EntXtract(int argnum, char **argv);
void EntReplace(int argnum, char **argv);

