#define	LIBQTOOLS_CORE
#include <libqtools.h>

/*
 * global vars
 */

int main(int argc, char **argv) {
  int i;
  char *outName = 0, *destDir = 0;
  bool script = TRUE;
  bool recurse = FALSE;
  operation procOper = OP_DEFAULT;
  unsigned char outType = TYPE_UNKNOWN;
  unsigned char arcType = TYPE_UNKNOWN;

  /* 
   * definition of interation:
   *  if there is some to put out, use that specific type
   *  else if there is some to get in, use the same specific type
   */
  for (i = 1; i < argc; i++) {
    if (!strcmp(argv[i], "-p")) {
      /*
       * palette-file 
       */
      argv[i] = 0;
      palFile = fopen(argv[++i], READ_BINARY);
      argv[i] = 0;
    }
    else if (!strcmp(argv[i], "-c")) {
      /*
       * colormap-file 
       */
      argv[i] = 0;
      colrFile = fopen(argv[++i], READ_BINARY);
      argv[i] = 0;
    }
    else if (!strcmp(argv[i], "-pp")) {
      /*
       * colormap-file 
       */
      argv[i] = 0;
      preProcessor = argv[++i];
      argv[i] = 0;
    }
    else if (!strcmp(argv[i], "-d")) {
      /*
       * dest-dir 
       */
      argv[i] = 0;
      destDir = argv[++i];
      argv[i] = 0;
    }
    else if (!strcmp(argv[i], "-l")) {
      /*
       * darkness-level 
       */
      char *tmp;

      argv[i] = 0;
      darkness = strtol(argv[++i], &tmp, 0);
      argv[i] = 0;
    }
    else if (!strcmp(argv[i], "-o")) {
      /*
       * specify output-name 
       */
      argv[i] = 0;
      outName = argv[++i];
      argv[i] = 0;
    }
    else if (!strcmp(argv[i], "-ppm")) {
      /*
       * convert to ppm 
       */
      argv[i] = 0;
      outType = TYPE_PPM;
    }
    else if (!strcmp(argv[i], "-jpg")) {
      /*
       * convert to jpg
       */
      argv[i] = 0;
      outType = TYPE_JPEG;
    }
    else if (!strcmp(argv[i], "-iff")) {
      /*
       * convert to iff
       */
      argv[i] = 0;
      outType = TYPE_ILBM;
    }
    else if (!strcmp(argv[i], "-png")) {
      /*
       * convert to png
       */
      argv[i] = 0;
      outType = TYPE_PNG;
    }
    else if (!strcmp(argv[i], "-vis")) {
      /*
       * create vis information
       */
      argv[i] = 0;
      arcType = TYPE_VIS;
    }
    else if (!strcmp(argv[i], "-watervis")) {
      /*
       * create vis information
       */
      argv[i] = 0;
      watervis = TRUE;
    }
    else if (!strcmp(argv[i], "-slimevis")) {
      /*
       * create vis information
       */
      argv[i] = 0;
      slimevis = TRUE;
    }
    else if (!strcmp(argv[i], "-waterlit")) {
      /*
       * create vis information
       */
      argv[i] = 0;
      waterlit = TRUE;
    }
    else if (!strcmp(argv[i], "-nofill")) {
      /*
       * create vis information
       */
      argv[i] = 0;
      nofill = TRUE;
    }
    else if (!strcmp(argv[i], "-notjunc")) {
      /*
       * create vis information
       */
      argv[i] = 0;
      notjunc = TRUE;
    }
    else if (!strcmp(argv[i], "-noclip")) {
      /*
       * create vis information
       */
      argv[i] = 0;
      noclip = TRUE;
    }
    else if (!strcmp(argv[i], "-onlyents")) {
      /*
       * create vis information
       */
      argv[i] = 0;
      onlyents = TRUE;
    }
    else if (!strcmp(argv[i], "-verbose")) {
      /*
       * create vis information
       */
      argv[i] = 0;
      verbose = TRUE;
    }
    else if (!strcmp(argv[i], "-fastvis")) {
      /*
       * create vis information
       */
      argv[i] = 0;
      fastvis = TRUE;
    }
    else if (!strcmp(argv[i], "-usehulls")) {
      /*
       * qbsp
       */
      argv[i] = 0;
      usehulls = TRUE;
    }
    else if (!strcmp(argv[i], "-scale")) {
      /*
       * qbsp-scale
       */
      argv[i] = 0;
      scale = atof(argv[++i]);
      argv[i] = 0;
    }
    else if (!strcmp(argv[i], "-range")) {
      /*
       * qbsp-scale
       */
      argv[i] = 0;
      range = atof(argv[++i]);
      argv[i] = 0;
    }
    else if (!strcmp(argv[i], "-vislevel")) {
      /*
       * vis-level 
       */
      char *tmp;

      argv[i] = 0;
      vislevel = strtol(argv[++i], &tmp, 0);
      argv[i] = 0;
    }
    else if (!strcmp(argv[i], "-hullnum")) {
      /*
       * qbsp-hullnum
       */
      char *tmp;

      argv[i] = 0;
      hullnum = strtol(argv[++i], &tmp, 0);
      argv[i] = 0;
    }
    else if (!strcmp(argv[i], "-subdivide")) {
      /*
       * qbsp-subdivide 
       */
      char *tmp;

      argv[i] = 0;
      subdivide = strtol(argv[++i], &tmp, 0);
      argv[i] = 0;
    }
    else if (!strcmp(argv[i], "-lit")) {
      /*
       * create vis information
       */
      argv[i] = 0;
      arcType = TYPE_LIT;
    }
    else if (!strcmp(argv[i], "-mip")) {
      /*
       * convert to mip
       */
      argv[i] = 0;
      /* set interaction to mip */
      arcType = TYPE_MIPMAP;
    }
    else if (!strcmp(argv[i], "-wal")) {
      /*
       * convert to mip
       */
      argv[i] = 0;
      /* set interaction to mip */
      arcType = outType = TYPE_WAL;
    }
    else if (!strcmp(argv[i], "-lump")) {
      /*
       * convert to lump 
       */
      argv[i] = 0;
      /* set interaction to lump */
      arcType = TYPE_LUMP;
    }
    else if (!strcmp(argv[i], "-ns")) {
      /*
       * no scripting  
       */
      argv[i] = 0;
      script = FALSE;
    }
    else if (!strcmp(argv[i], "-lz")) {
      /*
       * lz77 compression
       */
      argv[i] = 0;
      Compression |= CMP_LZ77;
    }
    else if (!strcmp(argv[i], "-mip0")) {
      /*
       * lz77 compression
       */
      argv[i] = 0;
      Compression |= CMP_MIP0;
    }
    else if (!strcmp(argv[i], "-dither")) {
      /*
       * dither ppm 
       */
      char *tmp;

      argv[i] = 0;
      dither = TRUE;
      if((argv[i + 1][0] != '-') && (argv[i + 1][0] >= '0') && (argv[i + 1][0] <= '9')) {
        dithervalue = strtol(argv[++i], &tmp, 0);
        argv[i] = 0;
        if (dithervalue < 16)
	  dithervalue = 16;
        if (dithervalue > 256)
	  dithervalue = 256;
      }
    }
    else if (!strcmp(argv[i], "-smooth")) {
      /*
       * smooth ppm 
       */
      char *tmp;

      argv[i] = 0;
      smoothing = TRUE;
      if((argv[i + 1][0] != '-') && (argv[i + 1][0] >= '0') && (argv[i + 1][0] <= '9')) {
        smoothingvalue = strtol(argv[++i], &tmp, 0);
        argv[i] = 0;
        if (smoothingvalue < 1)
	  smoothingvalue = 1;
        if (smoothingvalue > 256)
	  smoothingvalue = 256;
      }
    }
    else if (!strcmp(argv[i], "x")) {
      /*
       * extract the contents
       */
      argv[i] = 0;
      procOper = OP_EXTRACT;
    }
    else if (!strcmp(argv[i], "a")) {
      /*
       * add the contents
       */
      argv[i] = 0;
      procOper = OP_ADD;
    }
    else if (!strcmp(argv[i], "l")) {
      /*
       * list the contents
       */
      argv[i] = 0;
      procOper = OP_LIST;
    }
    else if (!strcmp(argv[i], "-h")) {
      mprintf("%s [-<options>] [<command>] <file> ...

  options :

   -c <colormap>       quake colormap lump
   -d <destdir>        alternative destination directory
   -dither [<value>]   dither floyd-steinberg with this error
   -smooth [<value>]   smooth with this fraction
   -l <darkness>       take this darkness
   -lump/-mip          specifies pic-conversion (in general for directory-conversions without \"-o\")
   -mip0               store only the first mip instead of all four (only for wads)
   -lz                 compress data with lz77 (only for wads)
   -ns                 do not write index-files
   -o <file>           specify archive-content or output-name
   -p <palette>        quake palette lump
   -ppm/-jpg/-iff/-png convert pictures and palettes to ppm/jpg/iff/png
   -r                  recurse extracting

  commands:

   a                   add
   d                   delete (unimplemented)
   l                   list (default)
   r                   replace (unimplemented)
   u                   update (unimplemented)
   v                   view (unimplemented)
   x                   extract

  examples:

   %s test.bsp test.pak test.wad test.mdl test.spr
    list all the contents of all the files
   %s x test.bsp test.pak test.wad test.mdl test.spr
    extract all the contents of all the files to the directory test.dir (bad :)
   %s x test1.bsp test2.pak test3.wad test4.mdl test/test5.spr
    extract all the contents of all the files to the directories test1.dir
    test2.dir test3.dir test4.dir test/test5.dir (good ;)
   %s -o *lava1 x test1.bsp
    extract the raw-mipmap-texture *lava1 to test1.dir/*lava1.mip
   %s -d test -o *lava1 x test1.bsp
    extract the raw-mipmap-texture *lava1 to test/test1.dir/*lava1.mip
   %s -o *lava1 x test1.wad
    extract the wad-content *lava1 to test1.dir/*lava1.<wad2-type>
   %s -ppm -o *lava1 x test1.wad
    extract the wad-content *lava1 to test1.dir/*lava1.ppm
   %s -ppm -o *lava1.mip x test1.wad
    extract the wad-content *lava1 to test1.dir/*lava1.mip with conversion to ppm
    *lava1.mip is NOT a raw-mipmap-texture, its a PPM

(all rights reserved, Niels Froehling, Dyna-Tech 1998)
", argv[0], argv[0], argv[0], argv[0], argv[0], argv[0], argv[0], argv[0], argv[0]);
      if (palFile)
        fclose(palFile);
      if (colrFile)
        fclose(colrFile);
      return 0;
    }
  }

  if(argc > 1) {
    for (i = 1; i < argc; i++) {
      if(argv[i]) {
        processName(argv[i], destDir, outName, outType, 0, arcType, procOper, script, recurse);
      }
    }
    if (palFile)
      fclose(palFile);
    if (colrFile)
      fclose(colrFile);
  }
  else
    mprintf("use -h for options\n");

  return 0;
}
