#define	LIBQTOOLS_CORE
#define	LIBQBUILD_CORE
#include <libqtools.h>
#include <libqbuild.h>
#include "../libqbuild/qcc.h"

extern char sourcedir[NAMELEN_PATH];				// 256
extern char destfile[NAMELEN_PATH];				// 256
extern bool pr_dumpasm;

extern bool InitData(void);
extern void PR_BeginCompilation(void *memory, int memsize);
extern bool PR_CompileFile(char *string, char *filename);
extern bool PR_FinishCompilation(void);
extern int PR_WriteProgdefs(char *filename);
extern void WriteData(int crc);
extern void WriteFiles(void);

extern char com_token[1024];
extern bool com_eof;

extern char *COM_Parse(register char *data);

/*
 * ============
 * main
 * ============
 */
#undef Error
static void Error(char *error,...)
{
  va_list argptr;

  eprintf("************ ERROR ************\n");

  va_start(argptr, error);
  vprintf(error, argptr);
  va_end(argptr);
  eprintf("\n");
  exit(1);
}

int main(int argc, char **argv)
{
  char *src;
  char *src2;
  char filename[1024];
  int p, crc;

  /*
   * p = CheckParm("-src");
   * if (p && p < argc - 1) {
   * strcpy(sourcedir, argv[p + 1]);
   * strcat(sourcedir, "/");
   * mprintf("Source directory: %s\n", sourcedir);
   * }
   * else
   */
  strcpy(sourcedir, "");

  InitData();

  sprintf(filename, "%sprogs.src", sourcedir);
  if (!(src = (char *)GetVoid(filename)))
    Error("cannot open %s\n", filename);

  src = COM_Parse(src);
  if (!src)
    Error("No destination filename.  qcc -help for info.\n");
  strcpy(destfile, com_token);
  mprintf("outputfile: %s\n", destfile);

  pr_dumpasm = FALSE;
  PR_BeginCompilation((void *)kmalloc(0x100000), 0x100000);

// compile all the files
  do {
    src = COM_Parse(src);
    if (!src)
      break;
    sprintf(filename, "%s%s", sourcedir, com_token);
    mprintf("compiling %s\n", filename);
    if (!(src2 = (char *)GetVoid(filename)))
      Error("cannot open %s\n", filename);

    if (!PR_CompileFile(src2, filename))
      exit(1);
  } while (1);

  if (!PR_FinishCompilation())
    Error("compilation errors");

// write progdefs.h
  crc = PR_WriteProgdefs("progdefs.h");

// write data file
  WriteData(crc);

// write files.dat
  WriteFiles();

  return 0;
}
