#include "qtools.h"

struct memory bspStatic;
struct memory *bspMem = &bspStatic;

/*
 * ===========
 * main
 * ===========
 */
int main(int argc, char **argv)
{
  char portalfile[NAMELEN_PATH];
  char source[NAMELEN_PATH];
  int i;
  int level = 2;
  FILE *bspFile;

  memset(bspMem, 0, sizeof(struct memory));
  if (!setjmp(eabort)) {
    mprintf("----- Vis ---------------\n");

    for (i = 1; i < argc; i++) {
      if (!strcmp(argv[i], "-fast")) {
        mprintf("fastvis = true\n");
        bspMem->visOptions |= VIS_FAST;
      }
      else if (!strcmp(argv[i], "-level")) {
        testvislevel = atoi(argv[i + 1]);
        mprintf("testvislevel = %i\n", testvislevel);
        i++;
      }
      else if (!strcmp(argv[i], "-v")) {
        mprintf("verbose = true\n");
        bspMem->visOptions |= VIS_VERBOSE;
      }
      else if (argv[i][0] == '-')
        Error("Unknown option \"%s\"", argv[i]);
      else
        break;
    }

    if (i != argc - 1)
      Error("usage: vis [-level 0-4] [-fast] [-v] bspfile");

    strcpy(source, argv[i]);
    ReplaceExt(source, "bsp");
    if((bspFile = fopen(source, READWRITE_BINARY_OLD))) {
      if((bspMem = LoadBSP(bspFile, ALL_LUMPS & ~LUMP_VISIBILITY))) {
        char *prtBuf;
    
        strcpy(portalfile, argv[i]);
        ReplaceExt(portalfile, "prt");
        
        if((prtBuf = (char *)GetVoid(portalfile))) {
          if(vis(bspMem, level, prtBuf) == FALSE)
            eprintf("failed to calculate vis-lump\n");
          else
            WriteBSP(bspFile, bspMem);
        
          tfree(prtBuf);
        }
        else
          eprintf("failed to load portalfile %s\n", portalfile);
        
        PrintClusters(bspMem, LUMP_VISIBILITY, TRUE);
        FreeClusters(bspMem, 0);
      }
      else
        eprintf("failed to load bspfile %s\n", source);
      
      fclose(bspFile);
    }
    else
      eprintf("failed to open bspfile %s\n", source);
  }

  return 0;
}
