#include "qtools.h"

struct memory bspStatic;
struct memory *bspMem = &bspStatic;

/*
 * ==================
 * main
 * 
 * ==================
 */
int main(int argc, char **argv)
{
  int i;
  char sourcename[NAMELEN_PATH];
  char destname[NAMELEN_PATH];
  int subdivide_size = 240;
  char *mapBuf;

  memset(bspMem, 0, sizeof(struct memory));
  if (!setjmp(eabort)) {
    //
    // check command line flags
    //
    for (i = 1; i < argc; i++) {
      if (argv[i][0] != '-')
        break;
      else if (!strcmp(argv[i], "-watervis"))
        bspMem->bspOptions |= QBSP_WATERVIS;
      else if (!strcmp(argv[i], "-slimevis"))
        bspMem->bspOptions |= QBSP_SLIMEVIS;
      else if (!strcmp(argv[i], "-notjunc"))
        bspMem->bspOptions |= QBSP_NOTJUNC;
      else if (!strcmp(argv[i], "-nofill"))
        bspMem->bspOptions |= QBSP_NOFILL;
      else if (!strcmp(argv[i], "-noclip"))
        bspMem->bspOptions |= QBSP_NOCLIP;
      else if (!strcmp(argv[i], "-onlyents"))
        bspMem->bspOptions |= QBSP_ONLYENTS;
      else if (!strcmp(argv[i], "-usehulls"))
        bspMem->bspOptions |= QBSP_USEHULLS;
      else if (!strcmp(argv[i], "-hullnum")) {
        hullnum = atoi(argv[i + 1]);
        i++;
      }
      else if (!strcmp(argv[i], "-subdivide")) {
        subdivide_size = atoi(argv[i + 1]);
        i++;
      }
      else
        Error("qbsp: Unknown option '%s'", argv[i]);
    }

    if (i != argc - 2 && i != argc - 1)
      Error("usage: qbsp [options] sourcefile [destfile]\noptions: -nojunc -nofill -draw -onlyents -verbose");

    //
    // let forked processes change name for ps status
    //
    argv0 = argv[0];

    //
    // create destination name if not specified
    //
    strcpy(sourcename, argv[i]);
    ReplaceExt(sourcename, "map");

    if((mapBuf = (char *)GetVoid(sourcename))) {
      BeginBSPFile(bspMem);
      
      if (LoadMapFile(bspMem, inData->rawdata) == TRUE) {
	if (qbsp(bspMem, hullnum, subdivide, bspName) == FALSE)
	  eprintf("failed to calculate bsp-tree\n");
	FinishBSPFile(bspMem, bspFile);
      }
      else
        eprintf("failed to parse map\n");
      
      tfree(mapBuf);
    }
    else
      eprintf("failed to load mapfile %s\n", sourcename);
  }

  return 0;
}
