#include "qtools.h"

struct memory bspStatic;
struct memory *bspMem = &bspStatic;


/*
 * ========
 * main
 * 
 * light modelfile
 * ========
 */
int main(int argc, char **argv)
{
  int i;
  char source[NAMELEN_PATH];
  FILE *bspFile;
  float scaledist = 0, rangescale = 0;

  memset(bspMem, 0, sizeof(struct memory));
  if (!setjmp(eabort)) {
    printf("----- LightFaces --------\n");

    for (i = 1; i < argc; i++) {
      if (!strcmp(argv[i], "-extra")) {
        bspMem->litOptions |= LIGHT_EXTRA;
        mprintf("extra sampling enabled\n");
      }
      else if (!strcmp(argv[i], "-rad")) {
        bspMem->litOptions |= LIGHT_RADIOSITY;
        mprintf("radiosity calculation enabled\n");
      }
      else if (!strcmp(argv[i], "-waterlit")) {
        bspMem->litOptions |= LIGHT_WATERLIT;
        mprintf("extra watershadowing enabled\n");
      }
      else if (!strcmp(argv[i], "-dist")) {
        scaledist = atof(argv[i + 1]);
        i++;
      }
      else if (!strcmp(argv[i], "-range")) {
        rangescale = atof(argv[i + 1]);
        i++;
      }
      else if (argv[i][0] == '-')
        Error("Unknown option \"%s\"", argv[i]);
      else
        break;
    }

    if (i != argc - 1)
      Error("usage: light [-extra] bspfile");

    strcpy(source, argv[i]);
    ReplaceExt(source, "bsp");
    if((bspFile = fopen(source, READWRITE_BINARY_OLD))) {
      if((bspMem = LoadBSP(bspFile, ALL_LUMPS & ~(LUMP_LIGHTING | LUMP_VISIBILITY)))) {
        if(light(bspMem, scaledist, rangescale) == FALSE)
          eprintf("failed to calculate light-lump\n");
        else        
          WriteBSP(bspFile, bspMem);

        PrintClusters(bspMem, LUMP_LIGHTING, TRUE);
        FreeClusters(bspMem, 0);
      }
      else
        eprintf("failed to open bspfile %s\n", source);
      
      fclose(bspFile);
    }
    else
      eprintf("failed to open bspfile %s\n", source);
  }

  return 0;
}
