#ifndef	SCRIPT_H
#define	SCRIPT_H

/*
 * ============================================================================
 * structures
 * ============================================================================
 */
typedef enum {
  OP_DEFAULT	= 'd',
  OP_UPDATE	= 'u',
  OP_REPLACE	= 'r',
  OP_ADD	= 'a',
  OP_DELETE	= 'd',
  OP_EXTRACT	= 'e',
  OP_LIST	= 'l',
  OP_VIEW	= 'v'
} __packed operation;

typedef enum {
  /* raw */
  TYPE_UNKNOWN		= 0,
#define	TYPE_NONE	TYPE_UNKNOWN
  TYPE_RAW		= 'R',
  TYPE_PALETTE		= '@',			// WAD2_PALETTE,
  
  /* archives */
  TYPE_WAD2		= 'w',
  TYPE_BSP		= 'b',
  TYPE_PACK		= 'p',
  TYPE_MODEL		= 'm',
  TYPE_SPRITE		= 's',
  TYPE_CODE		= 'c',
  TYPE_DEMO		= 'd',
  
  /* pictures */
  TYPE_PPM		= '6',
  TYPE_PGM		= '5',
  TYPE_PBM		= '1',
  TYPE_JPEG		= 'J',
  TYPE_ILBM		= 'I',
  TYPE_PNG		= 'P',
#define	TYPE_IMAGE	TYPE_PPM
  
  /* quake pictures */
  TYPE_MIPMAP		= 'D',			// WAD2_MIPMAP,
  TYPE_LUMP		= 'E',			// WAD2_CONPIC,
  TYPE_STATUSBAR	= 'B',			// WAD2_STATUSBAR,
  TYPE_SKIN		= 'S',
  TYPE_FRAME		= 'F',
  
  /* sounds */
  TYPE_WAVE		= 'W',
  
  /* texts */
  TYPE_RESOURCE		= 'R',
  TYPE_CONFIG		= 'C',
  TYPE_QUAKEC		= 'Q',
  
  /* 3d infos */
  TYPE_TRIANGLE		= 'T',
  TYPE_MAP		= 'M',
  TYPE_IMAGINE		= '3',
  
  /* specials */
  TYPE_INDEX		= 'x',
  TYPE_DIRECTORY	= 'y',
  
  /* very specials */
  TYPE_VIS		= 'v',
  TYPE_LIT		= 'l',
  TYPE_PRT		= 'r',
  
  /* quakeII */
  TYPE_WAL		= 'L'
} __packed filetype;

/*
 * ============================================================================
 * globals
 * ============================================================================
 */

/*
 * ============================================================================
 * prototypes
 * ============================================================================
 */

bool processName(char *procName, char *destDir, char *outName, filetype outType, char *arcName, filetype arcType, operation procOper, bool script, bool recurse);
bool processType(char *procName, filetype procType,
		 char *destDir,
		 char *outName, filetype outType,
		 char *arcName, filetype arcType,
		 operation procOper, 
		 bool script, bool recurse);
#endif
