#ifndef	RAW_H
#define	RAW_H
/*
 * ============================================================================
 * structures
 * ============================================================================
 */

struct rawdata {
  char *name;
  int size;
  char rawdata[0];
} __packed;

/*
 * ============================================================================
 * globals
 * ============================================================================
 */
extern FILE *palFile;
extern FILE *colrFile;
extern short int darkness, transparency;
extern struct rgb *cachedPalette;
extern unsigned char *cachedColormap;
extern unsigned char *cachedTransparency;
extern char Compression;

/*
 * ============================================================================
 * prototypes
 * ============================================================================
 */

struct palpic *pmalloc(register short int width, register short int height, register struct rgb *palette, register char *picName);
bool pfree(register struct palpic *Picture);
struct rawdata *rmalloc(register int size, char *rawName);
void rfree(register struct rawdata *rawData);

unsigned char *GetTransparency(int transVal);
struct rgb *GetDarkness(struct rgb *Palette);
struct rgb *GetPalette(void);

struct palpic *GetLMP(register FILE *file, register char *lmpName);
struct palpic *ParseLMP(register struct lump *Lump, register char *lmpName);
bool PutLMP(register FILE *file, register struct palpic *Picture);
bool PasteLMP(register struct lump *Lump, register struct palpic *Picture);

char *GetLZ77(register FILE *file, register int readsize);
char *ParseLZ77(register char *inData, register int readsize);
int PutLZ77(register FILE *file, register char *inData, register int size);
int PasteLZ77(register char *outData, register char *inData, register int size);

struct rawdata *GetRaw(register FILE *file, register char *rawName, register int size);
struct rawdata *ParseRaw(register char *mem, register char *rawName, register int size);
bool PutRaw(register FILE *file, register struct rawdata *rawData);
bool PasteRaw(register char *mem, register struct rawdata *rawData);
void FreeRaw(register struct rawdata *rawData);
#endif
