#ifndef	MISC_H
#define	MISC_H

/*
 * ============================================================================
 * structures
 * ============================================================================
 */
typedef union {
  char chars[4];
  int integer;
} magick;

#define NAMELEN_PATH 256
#define NAMELEN_MAXQUAKE 0x38

/*
 * ============================================================================
 * globals
 * ============================================================================
 */

extern char *preProcessor;

#ifdef	MEM_SIZETRACK
extern int memcounter;
extern int mempeak;
#ifdef	MEM_ANALYSE
extern int memallocs;
extern int mempeakallocs;
#endif
#endif

// longjump with this on bsp error
extern jmp_buf eabort;
extern bool verbose, fatal;

/*
 * ============================================================================
 * prototypes
 * ============================================================================
 */
#ifdef	MEM_SIZETRACK
int tmalloc(register int size);
void tfree(register void *adr);
int tsize(register void *adr);
int trealloc(register void *adr, register int newsize);
#else
#define tmalloc calloc
#define trealloc realloc
#define tfree free
#endif
int kmalloc(register int size);
void kfree(register void);
char *smalloc(register char *in);

void Error(char *error,...);
void eprintf(char *text, ...);
#ifdef VERBOSE
void oprintf(char *text, ...);
#else
#define	oprintf(text, args...)
#endif
void mprintf(char *text, ...);
void mprogress(register int max, register int current);

void CreatePath(register char *fileName);
char *GetExt(register char *Name);
void StripExt(register char *Name);
void ReplaceExt(register char *Name, register char *newExt);
char *GetFile(register char *Name);
void ValidateDir(register char *Name);
void *GetVoidF(register FILE *getFile);
void *GetVoid(register char *fileName);
void *GetPreProcessed(register char *fileName);
bool CutOff(FILE *procFile, int byteValue, void *buffer);
bool PasteIn(FILE *procFile, int byteValue, void *buffer);
#endif
