#define	LIBQTOOLS_CORE
#include "../include/libqtools.h"

char *preProcessor = 0;

/*
 * debug-tools
 */

#ifdef	MEM_SIZETRACK
#define	FRONTWALL	0
#define	BACKWALL	0

#ifdef	MEM_ANALYSE
int memcounter = 0;
int mempeak = 0;
int memallocs = 0;
int mempeakallocs = 0;
#endif

int tmalloc(register int size) {
  int *ret;

  /* use calloc instead ? */
  if ((ret = (int *)malloc(size + sizeof(int) + BACKWALL + FRONTWALL))) {
    memset(ret + ((sizeof(int) + FRONTWALL)/sizeof(int)), 0, size);
    
#ifdef	MEM_ANALYSE
    memcounter += size + sizeof(int) + BACKWALL + FRONTWALL;
    memallocs++;
    if(memcounter > mempeak)
      mempeak = memcounter;
    if(memallocs > mempeakallocs)
      mempeakallocs = memallocs;
    *ret++ = size;
#endif
    ret += (FRONTWALL/sizeof(int));
  }
  return (int)ret;
}

void tfree(register void *adr) {
  if (adr) {
#if defined(__amigaos__) && defined(DEBUG)
    int addr = (int)adr >> 28;
    
    if(addr) {
      eprintf("leak found for %lx\n", adr);
    }
    else {    
      int *ret = (int *)adr - (FRONTWALL/sizeof(int));

#ifdef	MEM_ANALYSE
      memcounter -= *--ret - sizeof(int) - BACKWALL - FRONTWALL;
      memallocs--;
#endif
      free(ret);
    }
#else
    int *ret = (int *)adr - (FRONTWALL/sizeof(int));

#ifdef	MEM_ANALYSE
    memcounter -= *--ret - sizeof(int) - BACKWALL - FRONTWALL;
    memallocs--;
#endif
    free(ret);
#endif
  }
}

int tsize(register void *adr) {
  if (adr)
    return *((int *)adr - (FRONTWALL/sizeof(int)) - sizeof(int));
  else
    return 0;
}

int trealloc(register void *adr, register int newsize) {
  if (adr) {
    int *ret;
    int oldsize = *((int *)adr - 1);
    
    if((ret = (int *)tmalloc(newsize))) {
      /* copy only valid bytes, leave more bytes cleared */
      memcpy(ret, adr, oldsize < newsize ? oldsize : newsize);
    }
    
    tfree(adr);
    return (int)ret;
  }
  else
    return tmalloc(newsize);
}
#endif

/*
 * an interface for temporary memtracking with automatic freeing after use
 */

struct memtrack {
  struct memtrack *next;
  int something[0];
};

struct memtrack *firstmalloc = 0;
struct memtrack *lastmalloc = 0;

int kmalloc(register int size) {
  struct memtrack *ret;
  
  if((ret = (struct memtrack *)tmalloc(size + sizeof(struct memtrack *)))) {
    if(!firstmalloc) {
      firstmalloc = ret;
      lastmalloc = ret;
    }
    else {
      lastmalloc->next = ret;
      lastmalloc = ret;
    }
  }
  return (int)&ret->something[0];
}

void kfree(register void) {
  if(firstmalloc) {
    struct memtrack *first = firstmalloc;
    struct memtrack *next;
    
    while(first) {
      next = first->next;
      tfree(first);
      first = next;
    }
    
    firstmalloc = 0;
    lastmalloc = 0;
  }
}

char *smalloc(register char *in) {
  char *string = 0;

  if(in)
    if((string = (char *)tmalloc(strlen(in) + 1)))
      strcpy(string, in);
  return string;
}

/*
 * message handling
 */

bool verbose = FALSE;
bool fatal = FALSE;
// longjump with this on error
jmp_buf eabort;

void Error(char *error,...)
{
  va_list argptr;

  printf("Error: ");
  va_start(argptr, error);
  vprintf(error, argptr);
  va_end(argptr);
  fflush(stdout);
  longjmp(eabort, 1);
}

void eprintf(char *text, ...) {
  va_list argptr;

  printf("Warning: ");
  va_start(argptr, text);
  vprintf(text, argptr);
  va_end(argptr);
  fflush(stdout);
  if(fatal == TRUE)
    longjmp(eabort, 1);
}

#ifdef	VERBOSE
void oprintf(char *text, ...) {
  if(verbose == TRUE) {
    va_list argptr;

    va_start(argptr, text);
    vprintf(text, argptr);
    va_end(argptr);
    fflush(stdout);
  }
}
#endif

void mprintf(char *text, ...) {
  va_list argptr;

  va_start(argptr, text);
  vprintf(text, argptr);
  va_end(argptr);
  fflush(stdout);
}

/*
 * platform-independent progressbar (text-based)
 */

void mprogress(register int max, register int current) {
#ifdef VALID_ESCAPES
  printf("\n\eM    - %2.2f%%", (float)(current * 100) / max);
  if(current >= max)
    printf("\n\eM");
  fflush(stdout);
#else
  printf("\xD\x9B\x4B    - %2.2f%%", (float)(current * 100) / max);
  if(current >= max)
    printf("\xD\x9B\x4B");
  fflush(stdout);
#endif
}

/*
 * disk-tools
 */

void CreatePath(register char *fileName) {
  char *delAdr1 = fileName, *delAdr2 = fileName;

  while ((delAdr2 = (char *)index(delAdr1, '/'))) {
    *delAdr2 = '\0';
    mkdir(fileName, 0x0777);
    *delAdr2 = '/';
    delAdr1 = ++delAdr2;
  }
}

char *GetExt(register char *Name) {
  if(Name) {
    char *Ext = (char *)rindex(Name, '.');

    if (!Ext)
      return (char *)index(Name, '\0');
    else {
      /*
       * delete everything after 4 chars 
       * Ext[4] = '\0';
       */
      return ++Ext;
    }
  }
  else
    return 0;
}

void StripExt(register char *Name) {
  if(Name) {
    char *Ext;

    if ((Ext = (char *)rindex(Name, '.')))
      *Ext = '\0';
  }
}

void ReplaceExt(register char *Name, register char *newExt) {
  if(Name) {
    char *Ext;

    if ((Ext = (char *)rindex(Name, '.'))) {
      *++Ext = '\0';
      strcpy(Ext, newExt);
    }
    else {
      strcat(Name, ".");
      strcat(Name, newExt);
    }
  }
}

/*
 * get the file-part of a path
 */
char *GetFile(register char *Name) {
  if(Name) {
    char *Ext = (char *)rindex(Name, '/');

    if (!Ext)
      return Name;
    else {
      return ++Ext;
    }
  }
  else
    return 0;
}

/*
 * check for valid unix-path
 */
void ValidateDir(register char *Name) {
  short int len = strlen(Name);
  while(Name[len] == '/')
    Name[len--] = '\0';
}

void *GetVoidF(register FILE *getFile) {
  void *voidData = 0;
  int size;

  fseek(getFile, 0, SEEK_END);
  size = ftell(getFile);
  fseek(getFile, 0, SEEK_SET);

  if ((voidData = (void *)tmalloc(size + 1))) {
    char *byteData = (char *)voidData;
    
    fread(voidData, 1, size, getFile);
    byteData[size] = '\0';
  }
  else
    eprintf("cannot tmalloc %d bytes memory for voiddata\n", size);
  
  return voidData;
}

void *GetVoid(register char *fileName) {
  FILE *getFile = fopen(fileName, READ_BINARY);
  void *voidData = 0;
  
  if(getFile) {
    voidData = GetVoidF(getFile);
    fclose(getFile);
  }

  return voidData;
}

void *GetPreProcessed(register char *fileName) {
  if(preProcessor) {
    char *tmpName;
    void *tmpData = 0;
    
    if((tmpName = tmpnam(0))) {
      char *exeLine;
      
      if((exeLine = (char *)tmalloc(strlen(preProcessor) + 1 + strlen(fileName) + 1 + strlen(tmpName) + 1))) {
        strcpy(exeLine, preProcessor);
        strcat(exeLine, " ");
        strcat(exeLine, fileName);
        strcat(exeLine, " ");
        strcat(exeLine, tmpName);
        
        system(exeLine);
        
        tmpData = GetVoid(tmpName);
        remove(tmpName);
      }
    }
    
    return tmpData;
  }
  else
    return GetVoid(fileName);
}

/*
 * cuts bytes out of a file
 * (file is REAL shorter)
 * stores cuttet bytes if buffer != 0
 */
bool CutOff(FILE *procFile, int byteValue, void *buffer) {
  int begin = ftell(procFile);
  int difference;

  if(buffer) {
    if(fread(buffer, 1, byteValue, procFile) != byteValue)
      return FALSE;
  }
  /*
   * cut of in steps
   */
  fseek(procFile, 0, SEEK_END);
  difference = ftell(procFile) - begin;
  if((buffer = (void *)tmalloc(difference))) {
    fseek(procFile, begin + byteValue, SEEK_SET);
    fread(buffer, 1, difference, procFile);
    fseek(procFile, begin, SEEK_SET);
    fwrite(buffer, 1, difference, procFile);
    //fsetsize(begin + difference - byteValue);
    fseek(procFile, begin, SEEK_SET);
    return TRUE;
  }
  else
    return FALSE;
}

/*
 * pastes bytes to a file
 * (file is REAL longer)
 * write bytes if buffer != 0
 */
bool PasteIn(FILE *procFile, int byteValue, void *buffer) {
  int begin = ftell(procFile);
  int difference;
  void *bufferNew;
  
  if(!buffer)
    buffer = (void *)memcounter;	/* copy something */
  
  /*
   * paste in in steps
   */
  fseek(procFile, 0, SEEK_END);
  difference = ftell(procFile) - begin;
  if((bufferNew = (void *)tmalloc(difference)) && buffer) {
    fseek(procFile, begin, SEEK_SET);
    fread(bufferNew, 1, difference, procFile);
    fseek(procFile, begin, SEEK_SET);
    fwrite(buffer, 1, byteValue, procFile);
    fwrite(bufferNew, 1, difference, procFile);
    fseek(procFile, begin, SEEK_SET);
    tfree(bufferNew);
    return TRUE;
  }
  else
    return FALSE;
}
