#ifndef	MIP_H
#define	MIP_H
/*
 * ============================================================================
 * structures
 * ============================================================================
 */
struct mipheader {
  int numtex;
  int offset[0];
};

enum mipmapoffset {
  MIPMAP_0 = 0,
  MIPMAP_1 = 1,
  MIPMAP_2 = 2,
  MIPMAP_3 = 3
} __packed;

#define	MIPMAP_MAX	4

#define NAMELEN_MIP	16
struct mipmap {
  char name[16];
  int width, height;
  int offsets[MIPMAP_MAX];
};

#define ANIM_MIPMAP	'+'
#define WARP_MIPMAP	'*'
#define	WARP_SHIFT	6
#define WARP_X		(1 << WARP_SHIFT)
#define WARP_Y		(1 << WARP_SHIFT)
#define	WARP_MASK	((1 << WARP_SHIFT) - 1)
#define SKY_MIPMAP	"sky"
#define SKY_X		256
#define SKY_Y		128

#define NAMELEN_WAL	32
struct wal {
  char name[32];
  int width, height;
  enum mipmapoffset offsets[MIPMAP_MAX];
  char animname[32];
  int flags, contents, value;
};

#define	MIP_MULT(x)	((x)+(x/(2*2))+(x/(4*4))+(x/(8*8)))

/*
 * ============================================================================
 * globals
 * ============================================================================
 */

/*
 * ============================================================================
 * prototypes
 * ============================================================================
 */

struct palpic *GetMipMap(FILE *file, enum mipmapoffset MipLevel);
struct palpic *ParseMipMap(struct mipmap *MipMap, enum mipmapoffset MipLevel);
bool PutMipMap(FILE *file, struct palpic *Picture);
bool PutMipMap0(FILE *file, struct palpic *Picture);
bool PasteMipMap(struct mipmap *MipMap, struct palpic *Picture);
bool PasteMipMap0(struct mipmap *MipMap, struct palpic *Picture);
#endif
