#define	LIBQTOOLS_CORE
#include "../include/libqtools.h"

/*
 * MIP-tools
 */

struct palpic *GetMipMap(FILE *file, enum mipmapoffset MipLevel) {
  struct mipmap MipMap;
  int MipMapSize, MipMapOffset;
  struct palpic *Picture = 0;

  fread(&MipMap, 1, sizeof(struct mipmap), file);
  if ((Picture = pmalloc(LittleLong(MipMap.width) >> MipLevel, LittleLong(MipMap.height) >> MipLevel, 0, MipMap.name))) {
    MipMapSize = (LittleLong(MipMap.width) >> MipLevel) * (LittleLong(MipMap.height) >> MipLevel);
    MipMapOffset = LittleLong(MipMap.offsets[MipLevel]) - sizeof(struct mipmap);
    fseek(file, MipMapOffset, SEEK_CUR);
    fread(Picture->rawdata, 1, MipMapSize, file);
  }

  return Picture;
}

struct palpic *ParseMipMap(struct mipmap *MipMap, enum mipmapoffset MipLevel) {
  int MipMapSize, MipMapOffset;
  struct palpic *Picture = 0;

  if ((Picture = pmalloc(LittleLong(MipMap->width) >> MipLevel, LittleLong(MipMap->height) >> MipLevel, 0, MipMap->name))) {
    MipMapSize = (LittleLong(MipMap->width) >> MipLevel) * (LittleLong(MipMap->height) >> MipLevel);
    MipMapOffset = LittleLong(MipMap->offsets[MipLevel]) - sizeof(struct mipmap);
    memcpy(Picture->rawdata, ((char *)MipMap) + MipMapOffset, MipMapSize);
  }

  return Picture;
}

/*
 * returns the offset or -1 for fail 
 */
bool PutMipMap(FILE *file, struct palpic *Picture) {
  struct mipmap MipMap;
  int MipMapSize;
  unsigned char *MipBody;
  bool retval = FALSE;
  
  /*
   * fix!!! OP_UPDATE offsets ??? 
   */
  MipMapSize = Picture->width * Picture->height;
  if ((MipBody = (unsigned char *)tmalloc(MipMapSize))) {
    short int x, y, num, dwidth = 1, dheight = 1, dshift = 1;
    unsigned char *bodySrc, *bodyDst;
    struct rgb *Palette = Picture->palette;

    strncpy(MipMap.name, Picture->name, NAMELEN_MIP);
    MipMap.height = LittleLong(Picture->height);
    MipMap.width = LittleLong(Picture->width);
    MipMap.offsets[MIPMAP_0] = LittleLong(sizeof(struct mipmap));
    MipMap.offsets[MIPMAP_1] = LittleLong(LittleLong(MipMap.offsets[MIPMAP_0]) + (MipMapSize / (1 * 1)));
    MipMap.offsets[MIPMAP_2] = LittleLong(LittleLong(MipMap.offsets[MIPMAP_1]) + (MipMapSize / (2 * 2)));
    MipMap.offsets[MIPMAP_3] = LittleLong(LittleLong(MipMap.offsets[MIPMAP_2]) + (MipMapSize / (4 * 4)));

    fwrite(&MipMap, 1, sizeof(struct mipmap), file);
    fwrite(bodySrc = Picture->rawdata, 1, MipMapSize, file);

    for (num = 0; num < 3; num++) {
      bodyDst = MipBody;
      dwidth <<= 1;
      dheight <<= 1;
      dshift++;
      for (y = 0; y < Picture->height; y += dheight) {
	for (x = 0; x < Picture->width; x += dwidth) {
	  short int dx, dy;
	  short int R = 0, G = 0, B = 0;
	  struct rgb rawpix;

	  for (dy = 0; dy < dheight; dy++) {
	    for (dx = 0; dx < dheight; dx++) {
	      short int palpix = (short int)bodySrc[((y + dy) * Picture->width) + x + dx];

	      R += (short int)Palette[palpix].r;
	      G += (short int)Palette[palpix].g;
	      B += (short int)Palette[palpix].b;
	    }
	  }
	  rawpix.r = (unsigned char)(R >> dshift);
	  rawpix.g = (unsigned char)(G >> dshift);
	  rawpix.b = (unsigned char)(B >> dshift);
	  *bodyDst++ = Match(&rawpix, Palette);
	}
      }
      fwrite(MipBody, 1, MipMapSize / (dheight * dwidth), file);
    }
    tfree(MipBody);
    retval = TRUE;
  }
  else
    eprintf("cannot tmalloc %d bytes-body\n", MipMapSize);

  return retval;
}

bool PutMipMap0(FILE *file, struct palpic *Picture) {
  struct mipmap MipMap;

  strncpy(MipMap.name, Picture->name, NAMELEN_MIP);
  MipMap.height = LittleLong(Picture->height);
  MipMap.width = LittleLong(Picture->width);
  MipMap.offsets[MIPMAP_0] = LittleLong(sizeof(struct mipmap));
  MipMap.offsets[MIPMAP_1] = 0;
  MipMap.offsets[MIPMAP_2] = 0;
  MipMap.offsets[MIPMAP_3] = 0;
  fwrite(&MipMap, 1, sizeof(struct mipmap), file);
  fwrite(Picture->rawdata, 1, Picture->width * Picture->height, file);

  return TRUE;
}

bool PasteMipMap(struct mipmap *MipMap, struct palpic *Picture) {
  int MipMapSize;
  unsigned char *MipBody;
  bool retval = FALSE;

  /*
   * fix!!! OP_UPDATE offsets ??? 
   */
  MipMapSize = Picture->width * Picture->height;
  if ((MipBody = (unsigned char *)tmalloc(MipMapSize))) {
    short int x, y, num, dwidth = 1, dheight = 1, dshift = 1, pos;
    unsigned char *bodySrc, *bodyDst;
    struct rgb *Palette = Picture->palette;

    strncpy(MipMap->name, Picture->name, NAMELEN_MIP);
    MipMap->height = LittleLong(Picture->height);
    MipMap->width = LittleLong(Picture->width);
    MipMap->offsets[MIPMAP_0] = LittleLong(sizeof(struct mipmap));
    MipMap->offsets[MIPMAP_1] = LittleLong(LittleLong(MipMap->offsets[MIPMAP_0]) + (MipMapSize / (1 * 1)));
    MipMap->offsets[MIPMAP_2] = LittleLong(LittleLong(MipMap->offsets[MIPMAP_1]) + (MipMapSize / (2 * 2)));
    MipMap->offsets[MIPMAP_3] = LittleLong(LittleLong(MipMap->offsets[MIPMAP_2]) + (MipMapSize / (4 * 4)));
    
    pos = sizeof(struct mipmap);

    memcpy(((char *)MipMap) + pos, bodySrc = Picture->rawdata, MipMapSize);
    pos += MipMapSize;

    for (num = 0; num < 3; num++) {
      bodyDst = MipBody;
      dwidth <<= 1;
      dheight <<= 1;
      dshift++;
      for (y = 0; y < Picture->height; y += dheight) {
	for (x = 0; x < Picture->width; x += dwidth) {
	  short int dx, dy;
	  short int R = 0, G = 0, B = 0;
	  struct rgb rawpix;

	  for (dy = 0; dy < dheight; dy++) {
	    for (dx = 0; dx < dheight; dx++) {
	      short int palpix = (short int)bodySrc[((y + dy) * Picture->width) + x + dx];

	      R += (short int)Palette[palpix].r;
	      G += (short int)Palette[palpix].g;
	      B += (short int)Palette[palpix].b;
	    }
	  }
	  rawpix.r = (unsigned char)(R >> dshift);
	  rawpix.g = (unsigned char)(G >> dshift);
	  rawpix.b = (unsigned char)(B >> dshift);
	  *bodyDst++ = Match(&rawpix, Palette);
	}
      }
      memcpy(((char *)MipMap) + pos, MipBody, MipMapSize / (dheight * dwidth));
      pos += MipMapSize / (dheight * dwidth);
    }
    tfree(MipBody);
    retval = TRUE;
  }
  else
    eprintf("cannot tmalloc %d bytes-body\n", MipMapSize);

  return retval;
}

bool PasteMipMap0(struct mipmap *MipMap, struct palpic *Picture) {
  strncpy(MipMap->name, Picture->name, NAMELEN_MIP);
  MipMap->height = LittleLong(Picture->height);
  MipMap->width = LittleLong(Picture->width);
  MipMap->offsets[MIPMAP_0] = LittleLong(sizeof(struct mipmap));
  MipMap->offsets[MIPMAP_1] = 0;
  MipMap->offsets[MIPMAP_2] = 0;
  MipMap->offsets[MIPMAP_3] = 0;
  memcpy(((char *)MipMap) + sizeof(struct mipmap), Picture->rawdata, Picture->width * Picture->height);

  return TRUE;
}

