#ifndef	MEMORY_H
#define	MEMORY_H
/*
 * ============================================================================
 * structures
 * ============================================================================
 */

/* key / value pair sizes */
#define	MAX_KEY			32
#define	MAX_VALUE		1024

#define	MAX_MAP_MODELS		256
#define	MAX_MAP_ENTSTRING	65536
#define	MAX_MAP_PLANES		8192	//    8192
#define	MAX_MAP_NODES		9216	//   32767	// because negative shorts are contents
#define	MAX_MAP_CLIPNODES	24576	//   32767	//
#define	MAX_MAP_LEAFS		6144	//   32767	//
#define	MAX_MAP_VERTS		23552	//   65535
#define	MAX_MAP_FACES		18432	//   65535
#define	MAX_MAP_MARKSURFACES	23552	//   65535
#define	MAX_MAP_TEXINFO		1024	//    4096
#define	MAX_MAP_EDGES		43008	//  256000
#define	MAX_MAP_SURFEDGES	82944	//  512000
#define	MAX_MAP_TEXTURES	0x200000
#define	MAX_MAP_LIGHTING	614400	//0x100000
#define	MAX_MAP_VISIBILITY	163840	//0x100000

#define CLUSTER_MODELS		32
#define CLUSTER_ENTSTRING	8192
#define CLUSTER_PLANES		512	//1024
#define CLUSTER_NODES		1024	//4096
#define CLUSTER_CLIPNODES	1024	//4096
#define CLUSTER_LEAFS		1024	//2048
#define CLUSTER_VERTS		2048	//8192
#define CLUSTER_FACES		1024	//4096
#define CLUSTER_MARKSURFACES	512	//892
#define CLUSTER_TEXINFO		512
#define CLUSTER_EDGES		4096	//16384
#define CLUSTER_SURFEDGES	4096	//16384
#define CLUSTER_TEXTURES	65536
#define CLUSTER_LIGHTING	65536
#define CLUSTER_VISIBILITY	32768

#define	LUMP_ENTITIES		(1<<0)
#define	LUMP_PLANES		(1<<1)
#define	LUMP_TEXTURES		(1<<2)
#define	LUMP_VERTEXES		(1<<3)
#define	LUMP_VISIBILITY		(1<<4)
#define	LUMP_NODES		(1<<5)
#define	LUMP_TEXINFO		(1<<6)
#define	LUMP_FACES		(1<<7)
#define	LUMP_LIGHTING		(1<<8)
#define	LUMP_CLIPNODES		(1<<9)
#define	LUMP_LEAFS		(1<<10)
#define	LUMP_MARKSURFACES	(1<<11)
#define	LUMP_EDGES		(1<<12)
#define	LUMP_SURFEDGES		(1<<13)
#define	LUMP_MODELS		(1<<14)

#define	ALL_LUMPS		(1<<15)-1

/*
 * ============================================================================
 */

#define	MAX_MAP_ENTITIES	1024
#define	MAX_MAP_TEXSTRINGS	MAX_MAP_TEXINFO
#define	MAX_MAP_BRUSHFACES	MAX_MAP_FACES
#define	MAX_MAP_BRUSHPLANES	MAX_MAP_PLANES

#define	CLUSTER_ENTITIES	128
#define	CLUSTER_TEXSTRINGS	CLUSTER_TEXINFO
#define	CLUSTER_BRUSHFACES	CLUSTER_FACES
#define	CLUSTER_BRUSHPLANES	CLUSTER_PLANES

#define	MAP_ENTITIES		(1<<15)
#define	MAP_TEXSTRINGS		(1<<16)
#define	MAP_BRUSHPLANES		(1<<17)
#define	MAP_BRUSHFACES	      	(1<<18)

#define	ALL_MAPS		(((1<<19)-1)-((1<<15)-1))

struct memory {
  int availHeaders;
  unsigned char mapOptions, bspOptions, litOptions, visOptions;
  
  /* standard bsp */
  int entdatasize,	max_entdatasize;	char *dentdata;
  int numplanes,	max_numplanes;		struct dplane_t *dplanes;
  int texdatasize,	max_texdatasize;	unsigned char *dtexdata;
  int numvertexes,	max_numvertexes;	struct dvertex_t *dvertexes;
  int visdatasize,	max_visdatasize;	unsigned char *dvisdata;
  int numnodes,		max_numnodes;		struct dnode_t *dnodes;
  int numtexinfo,	max_numtexinfo;		struct texinfo *texinfo;
  int numfaces,		max_numfaces;		struct dface_t *dfaces;
  int lightdatasize,	max_lightdatasize;	unsigned char *dlightdata;
  int numclipnodes,	max_numclipnodes;	struct dclipnode_t *dclipnodes;
  int numleafs,		max_numleafs;		struct dleaf_t *dleafs;
  int nummarksurfaces,	max_nummarksurfaces;	unsigned short int *dmarksurfaces;
  int numedges,		max_numedges;		struct dedge_t *dedges;
  int numsurfedges,	max_numsurfedges;	int *dsurfedges;
  int nummodels,	max_nummodels;		struct dmodel_t *dmodels;
  
  /* extras for maps */
  int nummapentities,	max_nummapentities;	struct entity *mapentities;
  int nummaptexstrings,	max_nummaptexstrings;	char **maptexstrings;
  int numbrushfaces,	max_numbrushfaces;	struct mface *brushfaces;
  int numbrushplanes,	max_numbrushplanes;	struct plane *brushplanes;
  
  /* extras */
  						struct visfacet **edgefaces[2];

  /* extras for light */
  
  /* extras for vis */
  
  /* configureable maximums */
#ifndef	CUSTOM_MAXIMA
# define	MAXEDGES		32	//64	//32
# define	MAXPOINTS		28	//56	//28		       	// don't let a base face get past this
										// because it can be split more later
# define	MAX_EDGES_IN_REGION	32
# define	MAX_PORTALS		32768
# define	MAX_PORTALS_ON_LEAF	128
#else
# define	DEFEDGES		32
# define	DEFPOINTS		28
# define	DEF_EDGES_IN_REGION	32
# define	DEF_PORTALS		32768
# define	DEF_PORTALS_ON_LEAF	128
# define	MAXPOINTS		bspMem->maxpoints
# define	MAXEDGES		bspMem->maxedges
# define	MAX_EDGES_IN_REGION	bspMem->maxedges_in_region
# define	MAX_PORTALS		bspMem->maxportals
# define	MAX_PORTALS_ON_LEAF	bspMem->maxportals_on_leaf
  int maxpoints;
  int maxedges;
  int maxedges_in_region;
  int maxportals;
  int maxportals_on_leaf;
#endif
} __packed;

/*
 * ============================================================================
 * prototypes
 * ============================================================================
 */

void PrintClusters(__memBase, int printType, bool toDisk);
void AllocClusters(__memBase, int allocType);
void ExpandClusters(__memBase, int allocType);
void FreeClusters(__memBase, int freeType);
#endif
