#define	LIBQTOOLS_CORE
#include "../include/libqtools.h"

//#define	DEBUG
//#define	DEBUG_EXPAND

/*
 * =============
 * PrintBSPFileSizes
 * 
 * Dumps info about current file
 * =============
 */
void PrintClusters(__memBase, int printType, bool toDisk)
{
  if (printType == 0)
    printType = bspMem->availHeaders;
  mprintf("----- Statistics --------\n");
  if (bspMem->availHeaders & printType & LUMP_PLANES)
    mprintf("%5i planes       %6i\n", bspMem->numplanes, (int)(bspMem->numplanes * sizeof(struct dplane_t)));

  if (bspMem->availHeaders & printType & LUMP_VERTEXES)
    mprintf("%5i vertexes     %6i\n", bspMem->numvertexes, (int)(bspMem->numvertexes * sizeof(struct dvertex_t)));

  if (bspMem->availHeaders & printType & LUMP_NODES)
    mprintf("%5i nodes        %6i\n", bspMem->numnodes, (int)(bspMem->numnodes * sizeof(struct dnode_t)));

  if (bspMem->availHeaders & printType & LUMP_TEXINFO)
    mprintf("%5i texinfo      %6i\n", bspMem->numtexinfo, (int)(bspMem->numtexinfo * sizeof(struct texinfo)));

  if (bspMem->availHeaders & printType & LUMP_FACES)
    mprintf("%5i faces        %6i\n", bspMem->numfaces, (int)(bspMem->numfaces * sizeof(struct dface_t)));

  if (bspMem->availHeaders & printType & LUMP_CLIPNODES)
    mprintf("%5i clipnodes    %6i\n", bspMem->numclipnodes, (int)(bspMem->numclipnodes * sizeof(struct dclipnode_t)));

  if (bspMem->availHeaders & printType & LUMP_LEAFS)
    mprintf("%5i leafs        %6i\n", bspMem->numleafs, (int)(bspMem->numleafs * sizeof(struct dleaf_t)));

  if (bspMem->availHeaders & printType & LUMP_MARKSURFACES)
    mprintf("%5i marksurfaces %6i\n", bspMem->nummarksurfaces, (int)(bspMem->nummarksurfaces * sizeof(unsigned short int)));

  if (bspMem->availHeaders & printType & LUMP_SURFEDGES)
    mprintf("%5i surfedges    %6i\n", bspMem->numsurfedges, (int)(bspMem->numsurfedges * sizeof(int)));

  if (bspMem->availHeaders & printType & LUMP_EDGES)
    mprintf("%5i edges        %6i\n", bspMem->numedges, (int)(bspMem->numedges * sizeof(struct dedge_t)));

  if (bspMem->availHeaders & printType & LUMP_TEXTURES)
    if (!bspMem->texdatasize)
      mprintf("    0 textures          0\n");
    else
      mprintf("%5i textures     %6i\n", toDisk == TRUE ? LittleLong(((struct dmiptexlump_t *)bspMem->dtexdata)->nummiptex) : ((struct dmiptexlump_t *)bspMem->dtexdata)->nummiptex, bspMem->texdatasize);
  if (bspMem->availHeaders & printType & LUMP_LIGHTING)
    mprintf("      lightdata    %6i\n", bspMem->lightdatasize);
  if (bspMem->availHeaders & printType & LUMP_VISIBILITY)
    mprintf("      visdata      %6i\n", bspMem->visdatasize);
  if (bspMem->availHeaders & printType & LUMP_ENTITIES)
    mprintf("      entdata      %6i\n", bspMem->entdatasize);

  if (bspMem->availHeaders & printType & MAP_ENTITIES)
    mprintf("%5i entities     %6i\n", bspMem->nummapentities, (int)(bspMem->nummapentities * sizeof(struct entity)));

  if (bspMem->availHeaders & printType & MAP_TEXSTRINGS)
    mprintf("%5i texstrings   %6i\n", bspMem->nummaptexstrings, (int)(bspMem->nummaptexstrings * (sizeof(char *) + 16)));

  if (bspMem->availHeaders & printType & MAP_BRUSHFACES)
    mprintf("%5i brushfaces  %6i\n", bspMem->numbrushfaces, (int)(bspMem->numbrushfaces * sizeof(struct mface)));

  if (bspMem->availHeaders & printType & MAP_BRUSHPLANES)
    mprintf("%5i brushplanes  %6i\n", bspMem->numbrushplanes, (int)(bspMem->numbrushplanes * sizeof(struct plane)));
}

/*
 * =============
 * AllocBSP
 * =============
 */
void AllocClusters(__memBase, int allocType)
{
  if (bspMem) {
    if (allocType & LUMP_ENTITIES) {
      if (bspMem->dentdata)
	tfree(bspMem->dentdata);
      if (!(bspMem->dentdata = tmalloc((bspMem->max_entdatasize = CLUSTER_ENTSTRING) * sizeof(char))))
	Error("failed to allocate bytes");
      bspMem->entdatasize = 0;
      oprintf("first cluster for entities allocated: %7d bytes (%lx)\n", CLUSTER_ENTSTRING * sizeof(char), bspMem->dentdata);
    }
    if (allocType & LUMP_PLANES) {
      if (bspMem->dplanes)
	tfree(bspMem->dplanes);
      if (!(bspMem->dplanes = tmalloc((bspMem->max_numplanes = CLUSTER_PLANES) * sizeof(struct dplane_t))))
	Error("failed to allocate bytes");
      bspMem->numplanes = 0;
      oprintf("first cluster for planes allocated: %7d bytes (%lx)\n", CLUSTER_PLANES * sizeof(struct dplane_t), bspMem->dplanes);
    }
    if (allocType & LUMP_TEXTURES) {
      if (bspMem->dtexdata)
	tfree(bspMem->dtexdata);
      if (!(bspMem->dtexdata = tmalloc((bspMem->max_texdatasize = CLUSTER_TEXTURES) * sizeof(char))))
	Error("failed to allocate bytes");
      bspMem->texdatasize = 0;
      oprintf("first cluster for textures allocated: %7d bytes (%lx)\n", CLUSTER_TEXTURES * sizeof(char), bspMem->dtexdata);
    }
    if (allocType & LUMP_VERTEXES) {
      if (bspMem->dvertexes)
	tfree(bspMem->dvertexes);
      if (!(bspMem->dvertexes = tmalloc((bspMem->max_numvertexes = CLUSTER_VERTS) * sizeof(struct dvertex_t))))
	Error("failed to allocate bytes");
      bspMem->numvertexes = 0;
      oprintf("first cluster for vertexes allocated: %7d bytes (%lx)\n", CLUSTER_VERTS * sizeof(struct dvertex_t), bspMem->dvertexes);
    }
    if (allocType & LUMP_VISIBILITY) {
      if (bspMem->dvisdata)
	tfree(bspMem->dvisdata);
      if (!(bspMem->dvisdata = tmalloc((bspMem->max_visdatasize = CLUSTER_VISIBILITY) * sizeof(char))))
	Error("failed to allocate bytes");
      bspMem->visdatasize = 0;
      oprintf("first cluster for visibility allocated: %7d bytes (%lx)\n", CLUSTER_VISIBILITY * sizeof(char), bspMem->dvisdata);
    }
    if (allocType & LUMP_NODES) {
      if (bspMem->dnodes)
	tfree(bspMem->dnodes);
      if (!(bspMem->dnodes = tmalloc((bspMem->max_numnodes = CLUSTER_NODES) * sizeof(struct dnode_t))))
	Error("failed to allocate bytes");
      bspMem->numnodes = 0;
      oprintf("first cluster for nodes allocated: %7d bytes (%lx)\n", CLUSTER_NODES * sizeof(struct dnode_t), bspMem->dnodes);
    }
    if (allocType & LUMP_TEXINFO) {
      if (bspMem->texinfo)
	tfree(bspMem->texinfo);
      if (!(bspMem->texinfo = tmalloc((bspMem->max_numtexinfo = CLUSTER_TEXINFO) * sizeof(struct texinfo))))
	Error("failed to allocate bytes");
      bspMem->numtexinfo = 0;
      oprintf("first cluster for texinfo allocated: %7d bytes (%lx)\n", CLUSTER_TEXINFO * sizeof(struct texinfo), bspMem->texinfo);
    }
    if (allocType & LUMP_FACES) {
      if (bspMem->dfaces)
	tfree(bspMem->dfaces);
      if (!(bspMem->dfaces = tmalloc((bspMem->max_numfaces = CLUSTER_FACES) * sizeof(struct dface_t))))
	Error("failed to allocate bytes");
      bspMem->numfaces = 0;
      oprintf("first cluster for faces allocated: %7d bytes (%lx)\n", CLUSTER_FACES * sizeof(struct dface_t), bspMem->dfaces);
    }
    if (allocType & LUMP_LIGHTING) {
      if (bspMem->dlightdata)
	tfree(bspMem->dlightdata);
      if (!(bspMem->dlightdata = tmalloc((bspMem->max_lightdatasize = CLUSTER_LIGHTING) * sizeof(char))))
	Error("failed to allocate bytes");
      bspMem->lightdatasize = 0;
      oprintf("first cluster for lighting allocated: %7d bytes (%lx)\n", CLUSTER_LIGHTING * sizeof(char), bspMem->dlightdata);
    }
    if (allocType & LUMP_CLIPNODES) {
      if (bspMem->dclipnodes)
	tfree(bspMem->dclipnodes);
      if (!(bspMem->dclipnodes = tmalloc((bspMem->max_numclipnodes = CLUSTER_CLIPNODES) * sizeof(struct dclipnode_t))))
	Error("failed to allocate bytes");
      bspMem->numclipnodes = 0;
      oprintf("first cluster for clipnodes allocated: %7d bytes (%lx)\n", CLUSTER_CLIPNODES * sizeof(struct dclipnode_t), bspMem->dclipnodes);
    }
    if (allocType & LUMP_LEAFS) {
      if (bspMem->dleafs)
	tfree(bspMem->dleafs);
      if (!(bspMem->dleafs = tmalloc((bspMem->max_numleafs = CLUSTER_LEAFS) * sizeof(struct dleaf_t))))
	Error("failed to allocate bytes");
      bspMem->numleafs = 0;
      oprintf("first cluster for leafs allocated: %7d bytes (%lx)\n", CLUSTER_LEAFS * sizeof(struct dleaf_t), bspMem->dleafs);
    }
    if (allocType & LUMP_MARKSURFACES) {
      if (bspMem->dmarksurfaces)
	tfree(bspMem->dmarksurfaces);
      if (!(bspMem->dmarksurfaces = tmalloc((bspMem->max_nummarksurfaces = CLUSTER_MARKSURFACES) * sizeof(unsigned short int))))
	Error("failed to allocate bytes");
      bspMem->nummarksurfaces = 0;
      oprintf("first cluster for marksurfaces allocated: %7d bytes (%lx)\n", CLUSTER_MARKSURFACES * sizeof(unsigned short int), bspMem->dmarksurfaces);
    }
    if (allocType & LUMP_EDGES) {
      if (bspMem->dedges)
	tfree(bspMem->dedges);
      if (bspMem->edgefaces[0])
	tfree(bspMem->edgefaces[0]);
      if (bspMem->edgefaces[1])
	tfree(bspMem->edgefaces[1]);
	
      if (!(bspMem->dedges = tmalloc((bspMem->max_numedges = CLUSTER_EDGES) * sizeof(struct dedge_t))))
	Error("failed to allocate bytes");
      if (!(bspMem->edgefaces[0] = tmalloc(CLUSTER_EDGES * sizeof(struct visfacet **))))
	  Error("failed to allocate bytes");
      if (!(bspMem->edgefaces[1] = tmalloc(CLUSTER_EDGES * sizeof(struct visfacet **))))
	  Error("failed to allocate bytes");

      bspMem->numedges = 0;
      oprintf("first cluster for edges allocated: %7d bytes (%lx)\n", CLUSTER_EDGES * sizeof(struct dedge_t), bspMem->dedges);
      oprintf("first cluster for edgefaces[0] allocated: %7d bytes (%lx)\n", CLUSTER_EDGES * sizeof(struct visfacet **), bspMem->edgefaces[0]);
      oprintf("first cluster for edgefaces[1] allocated: %7d bytes (%lx)\n", CLUSTER_EDGES * sizeof(struct visfacet **), bspMem->edgefaces[1]);
    }
    if (allocType & LUMP_SURFEDGES) {
      if (bspMem->dsurfedges)
	tfree(bspMem->dsurfedges);
      if (!(bspMem->dsurfedges = tmalloc((bspMem->max_numsurfedges = CLUSTER_SURFEDGES) * sizeof(int))))
	Error("failed to allocate bytes");
      bspMem->numsurfedges = 0;
      oprintf("first cluster for surfedges allocated: %7d bytes (%lx)\n", CLUSTER_SURFEDGES * sizeof(int), bspMem->dsurfedges);
    }
    if (allocType & LUMP_MODELS) {
      if (bspMem->dmodels)
	tfree(bspMem->dmodels);
      if (!(bspMem->dmodels = tmalloc((bspMem->max_nummodels = CLUSTER_MODELS) * sizeof(struct dmodel_t))))
	Error("failed to allocate bytes");
      bspMem->nummodels = 0;
      oprintf("first cluster for models allocated: %7d bytes (%lx)\n", CLUSTER_MODELS * sizeof(struct dmodel_t), bspMem->dmodels);
    }
    if (allocType & MAP_ENTITIES) {
      if (bspMem->mapentities)
	tfree(bspMem->mapentities);
      if (!(bspMem->mapentities = tmalloc((bspMem->max_nummapentities = CLUSTER_ENTITIES) * sizeof(struct entity))))
	Error("failed to allocate bytes");
      bspMem->nummapentities = 0;
      oprintf("first cluster for brushes allocated: %7d bytes (%lx)\n", CLUSTER_ENTITIES * sizeof(struct entity), bspMem->mapentities);
    }
    if (allocType & MAP_TEXSTRINGS) {
      int i;
      char *text;

      if (bspMem->maptexstrings)
	tfree(bspMem->maptexstrings);
      if (!(bspMem->maptexstrings = tmalloc((bspMem->max_nummaptexstrings = CLUSTER_TEXSTRINGS) * (sizeof(char *) + 16))))
	Error("failed to allocate bytes");
      bspMem->nummaptexstrings = 0;
      for (i = 0, text = (char *)&bspMem->maptexstrings[bspMem->max_nummaptexstrings]; i < bspMem->max_nummaptexstrings; i++, text += 16)
	bspMem->maptexstrings[i] = text;
      oprintf("first cluster for texstrings allocated: %7d bytes (%lx)\n", CLUSTER_TEXSTRINGS * (sizeof(char *) + 16), bspMem->maptexstrings);
    }
    if (allocType & MAP_BRUSHFACES) {
      if (bspMem->brushfaces)
	tfree(bspMem->brushfaces);
      if (!(bspMem->brushfaces = tmalloc((bspMem->max_numbrushfaces = CLUSTER_BRUSHFACES) * sizeof(struct mface))))
	Error("failed to allocate bytes");
      bspMem->numbrushfaces = 0;
      oprintf("first cluster for brushfaces allocated: %7d bytes (%lx)\n", CLUSTER_BRUSHFACES * sizeof(struct mface), bspMem->brushfaces);
    }
    if (allocType & MAP_BRUSHPLANES) {
      if (bspMem->brushplanes)
	tfree(bspMem->brushplanes);
      if (!(bspMem->brushplanes = tmalloc((bspMem->max_numbrushplanes = CLUSTER_BRUSHPLANES) * sizeof(struct plane))))
	Error("failed to allocate bytes");
      bspMem->numbrushplanes = 0;
      oprintf("first cluster for brushes allocated: %7d bytes (%lx)\n", CLUSTER_BRUSHPLANES * sizeof(struct plane), bspMem->brushplanes);
    }
    bspMem->availHeaders |= allocType;
#ifdef	CUSTOM_MAXIMA
    if (!bspMem->maxpoints)
      bspMem->maxpoints = DEFPOINTS;
    if (!bspMem->maxedges)
      bspMem->maxedges = DEFEDGES;
    if (!bspMem->maxedges_in_region)
      bspMem->maxedges_in_region = DEF_EDGES_IN_REGION;
    if (!bspMem->maxportals)
      bspMem->maxportals = DEF_PORTALS;
    if (!bspMem->maxportals_in_leaf)
      bspMem->maxportals_in_leaf = DEF_PORTALS_IN_LEAF;
#endif
  }
}

/*
 * =============
 * ExpandBSP
 * =============
 * for all use trealloc instead ?
 */
void ExpandClusters(__memBase, int allocType)
{
  if (bspMem) {
    if (allocType & LUMP_ENTITIES) {
      if (!(bspMem->dentdata = trealloc(bspMem->dentdata, (bspMem->max_entdatasize += CLUSTER_ENTSTRING) * sizeof(char))))
	Error("failed to allocate bytes");
      oprintf("additional cluster for entities allocated: %7d bytes (%lx)\n", bspMem->max_entdatasize * sizeof(char), bspMem->dentdata);
    }
    if (allocType & LUMP_PLANES) {
      if (!(bspMem->dplanes = trealloc(bspMem->dplanes, (bspMem->max_numplanes += CLUSTER_PLANES) * sizeof(struct dplane_t))))
	Error("failed to allocate bytes");
	oprintf("additional cluster for planes allocated: %7d bytes (%lx)\n", bspMem->max_numplanes * sizeof(struct dplane_t), bspMem->dplanes);
    }
    if (allocType & LUMP_TEXTURES) {
      if (!(bspMem->dtexdata = trealloc(bspMem->dtexdata, (bspMem->max_texdatasize += CLUSTER_TEXTURES) * sizeof(char))))
	Error("failed to allocate bytes");
	oprintf("additional cluster for textures allocated: %7d bytes (%lx)\n", bspMem->max_texdatasize * sizeof(char), bspMem->dtexdata);
    }
    if (allocType & LUMP_VERTEXES) {
      if (!(bspMem->dvertexes = trealloc(bspMem->dvertexes, (bspMem->max_numvertexes += CLUSTER_VERTS) * sizeof(struct dvertex_t))))
	Error("failed to allocate bytes");
	oprintf("additional cluster for vertexes allocated: %7d bytes (%lx)\n", bspMem->max_numvertexes * sizeof(struct dvertex_t), bspMem->dvertexes);
    }
    if (allocType & LUMP_VISIBILITY) {
      if (!(bspMem->dvisdata = trealloc(bspMem->dvisdata, (bspMem->max_visdatasize += CLUSTER_VISIBILITY) * sizeof(char))))
	Error("failed to allocate bytes");
	oprintf("additional cluster for visibility allocated: %7d bytes (%lx)\n", bspMem->max_visdatasize * sizeof(char), bspMem->dvisdata);
    }
    if (allocType & LUMP_NODES) {
      if ((bspMem->dnodes = trealloc(bspMem->dnodes, (bspMem->max_numnodes += CLUSTER_NODES) * sizeof(struct dnode_t))))
	Error("failed to allocate bytes");
	oprintf("additional cluster for nodes allocated: %7d bytes (%lx)\n", bspMem->max_numnodes * sizeof(struct dnode_t), bspMem->dnodes);
    }
    if (allocType & LUMP_TEXINFO) {
      if (!(bspMem->texinfo = trealloc(bspMem->texinfo, (bspMem->max_numtexinfo += CLUSTER_TEXINFO) * sizeof(struct texinfo))))
	Error("failed to allocate bytes");
	oprintf("additional cluster for texinfo allocated: %7d bytes (%lx)\n", bspMem->max_numtexinfo * sizeof(struct texinfo), bspMem->texinfo);
    }
    if (allocType & LUMP_FACES) {
      if (!(bspMem->dfaces = trealloc(bspMem->dfaces, (bspMem->max_numfaces += CLUSTER_FACES) * sizeof(struct dface_t))))
	Error("failed to allocate bytes");
	oprintf("additional cluster for faces allocated: %7d bytes (%lx)\n", bspMem->max_numfaces * sizeof(struct dface_t), bspMem->dfaces);
    }
    if (allocType & LUMP_LIGHTING) {
      if (!(bspMem->dlightdata = trealloc(bspMem->dlightdata, (bspMem->max_lightdatasize += CLUSTER_LIGHTING) * sizeof(char))))
	Error("failed to allocate bytes");
	oprintf("additional cluster for lighting allocated: %7d bytes (%lx)\n", bspMem->max_lightdatasize * sizeof(char), bspMem->dlightdata);
    }
    if (allocType & LUMP_CLIPNODES) {
      if (!(bspMem->dclipnodes = trealloc(bspMem->dclipnodes, (bspMem->max_numclipnodes += CLUSTER_CLIPNODES) * sizeof(struct dclipnode_t))))
	Error("failed to allocate bytes");
	oprintf("additional cluster for clipnodes allocated: %7d bytes (%lx)\n", bspMem->max_numclipnodes * sizeof(struct dclipnode_t), bspMem->dclipnodes);
    }
    if (allocType & LUMP_LEAFS) {
      if (!(bspMem->dleafs = trealloc(bspMem->dleafs, (bspMem->max_numleafs += CLUSTER_LEAFS) * sizeof(struct dleaf_t))))
	Error("failed to allocate bytes");
	oprintf("additional cluster for leafs allocated: %7d bytes (%lx)\n", bspMem->max_numleafs * sizeof(struct dleaf_t), bspMem->dleafs);
    }
    if (allocType & LUMP_MARKSURFACES) {
      if (!(bspMem->dmarksurfaces = trealloc(bspMem->dmarksurfaces, (bspMem->max_nummarksurfaces += CLUSTER_MARKSURFACES) * sizeof(unsigned short int))))
	Error("failed to allocate bytes");
	oprintf("additional cluster for marksurfaces allocated: %7d bytes (%lx)\n", bspMem->max_nummarksurfaces * sizeof(unsigned short int), bspMem->dmarksurfaces);
    }
    if (allocType & LUMP_EDGES) {
      if (!(bspMem->dedges = trealloc(bspMem->dedges, (bspMem->max_numedges += CLUSTER_EDGES) * sizeof(struct dedge_t))))
	Error("failed to allocate bytes");
      if (!(bspMem->edgefaces[0] = trealloc(bspMem->edgefaces[0], bspMem->max_numedges * sizeof(struct visfacet **))))
	Error("failed to allocate bytes");
      if (!(bspMem->edgefaces[1] = trealloc(bspMem->edgefaces[1], bspMem->max_numedges * sizeof(struct visfacet **))))
	Error("failed to allocate bytes");
      oprintf("additional cluster for edges allocated: %7d bytes (%lx)\n", bspMem->max_numedges * sizeof(struct dedge_t), bspMem->dedges);
      oprintf("additional cluster for edgefaces[0] allocated: %7d bytes (%lx)\n", bspMem->max_numedges * sizeof(struct visfacet **), bspMem->edgefaces[0]);
      oprintf("additional cluster for edgefaces[1] allocated: %7d bytes (%lx)\n", bspMem->max_numedges * sizeof(struct visfacet **), bspMem->edgefaces[1]);
    }
    if (allocType & LUMP_SURFEDGES) {
      if (!(bspMem->dsurfedges = trealloc(bspMem->dsurfedges, (bspMem->max_numsurfedges += CLUSTER_SURFEDGES) * sizeof(int))))
	Error("failed to allocate bytes");
	oprintf("additional cluster for surfedges allocated: %7d bytes (%lx)\n", bspMem->max_numsurfedges * sizeof(int), bspMem->dsurfedges);
    }
    if (allocType & LUMP_MODELS) {
      if (!(bspMem->dmodels = trealloc(bspMem->dmodels, (bspMem->max_nummodels += CLUSTER_MODELS) * sizeof(struct dmodel_t))))
	Error("failed to allocate bytes");
	oprintf("additional cluster for models allocated: %7d bytes (%lx)\n", bspMem->max_nummodels * sizeof(struct dmodel_t), bspMem->dmodels);
    }
    if (allocType & MAP_ENTITIES) {
      if (!(bspMem->mapentities = trealloc(bspMem->mapentities, (bspMem->max_nummapentities += CLUSTER_ENTITIES) * sizeof(struct entity))))
	Error("failed to allocate bytes");
	oprintf("additional cluster for mapentities allocated: %7d bytes (%lx)\n", bspMem->max_nummapentities * sizeof(struct entity), bspMem->mapentities);
    }
    if (allocType & MAP_TEXSTRINGS) {
      int i;
      char *text;
      char **maptexstrings = bspMem->maptexstrings;
      if (!(bspMem->maptexstrings = tmalloc((bspMem->max_nummaptexstrings += CLUSTER_TEXSTRINGS) * (sizeof(char *) + 16))))
	Error("failed to allocate bytes");
	
      for (i = 0, text = (char *)&bspMem->maptexstrings[bspMem->max_nummaptexstrings]; i < bspMem->max_nummaptexstrings; i++, text += 16)
	bspMem->maptexstrings[i] = text;
      memcpy(bspMem->maptexstrings[0], maptexstrings[0], bspMem->nummaptexstrings * 16);
      tfree(maptexstrings);
	oprintf("additional cluster for mapstrings allocated: %7d bytes (%lx)\n", bspMem->max_nummaptexstrings * (sizeof(char *) + 16), bspMem->maptexstrings);
    }
    if (allocType & MAP_BRUSHFACES) {
      if (!(bspMem->brushfaces = trealloc(bspMem->brushfaces, (bspMem->max_numbrushplanes += CLUSTER_BRUSHFACES) * sizeof(struct mface))))
	Error("failed to allocate bytes");
	oprintf("additional cluster for brushplanes allocated: %7d bytes (%lx)\n", bspMem->max_numbrushplanes * sizeof(struct mface), bspMem->brushfaces);
    }
    if (allocType & MAP_BRUSHPLANES) {
      if (!(bspMem->brushplanes = trealloc(bspMem->brushplanes, (bspMem->max_numbrushplanes += CLUSTER_BRUSHPLANES) * sizeof(struct plane))))
	Error("failed to allocate bytes");
	oprintf("additional cluster for brushplanes allocated: %7d bytes (%lx)\n", bspMem->max_numbrushplanes * sizeof(struct plane), bspMem->brushplanes);
    }
    bspMem->availHeaders |= allocType;
#ifdef	CUSTOM_MAXIMA
    if (!bspMem->maxpoints)
      bspMem->maxpoints = DEFPOINTS;
    if (!bspMem->maxedges)
      bspMem->maxedges = DEFEDGES;
    if (!bspMem->maxedges_in_region)
      bspMem->maxedges_in_region = DEF_EDGES_IN_REGION;
    if (!bspMem->maxportals)
      bspMem->maxportals = DEF_PORTALS;
    if (!bspMem->maxportals_in_leaf)
      bspMem->maxportals_in_leaf = DEF_PORTALS_IN_LEAF;
#endif
  }
}

/*
 * =============
 * FreeBSP
 * =============
 */
void FreeClusters(__memBase, int freeType)
{
  if (bspMem) {
    if (!freeType)
      freeType = bspMem->availHeaders;

    oprintf("free entities\n");
    if ((bspMem->availHeaders & freeType & LUMP_ENTITIES))
      tfree(bspMem->dentdata);
    oprintf("free planes\n");
    if ((bspMem->availHeaders & freeType & LUMP_PLANES))
      tfree(bspMem->dplanes);
    oprintf("free textures\n");
    if ((bspMem->availHeaders & freeType & LUMP_TEXTURES))
      tfree(bspMem->dtexdata);
    oprintf("free vertexes\n");
    if ((bspMem->availHeaders & freeType & LUMP_VERTEXES))
      tfree(bspMem->dvertexes);
    oprintf("free visibility\n");
    if ((bspMem->availHeaders & freeType & LUMP_VISIBILITY))
      tfree(bspMem->dvisdata);
    oprintf("free nodes\n");
    if ((bspMem->availHeaders & freeType & LUMP_NODES))
      tfree(bspMem->dnodes);
    oprintf("free texinfo\n");
    if ((bspMem->availHeaders & freeType & LUMP_TEXINFO))
      tfree(bspMem->texinfo);
    oprintf("free faces\n");
    if ((bspMem->availHeaders & freeType & LUMP_FACES))
      tfree(bspMem->dfaces);
    oprintf("free lighting\n");
    if ((bspMem->availHeaders & freeType & LUMP_LIGHTING))
      tfree(bspMem->dlightdata);
    oprintf("free clipnodes\n");
    if ((bspMem->availHeaders & freeType & LUMP_CLIPNODES))
      tfree(bspMem->dclipnodes);
    oprintf("free leafs\n");
    if ((bspMem->availHeaders & freeType & LUMP_LEAFS))
      tfree(bspMem->dleafs);
    oprintf("free marksurfaces\n");
    if ((bspMem->availHeaders & freeType & LUMP_MARKSURFACES))
      tfree(bspMem->dmarksurfaces);
    oprintf("free edges\n");
    if ((bspMem->availHeaders & freeType & LUMP_EDGES)) {
      tfree(bspMem->dedges);
      if (bspMem->edgefaces[0])
	tfree(bspMem->edgefaces[0]);
      if (bspMem->edgefaces[1])
	tfree(bspMem->edgefaces[1]);
    }
    oprintf("free surfedges\n");
    if ((bspMem->availHeaders & freeType & LUMP_SURFEDGES))
      tfree(bspMem->dsurfedges);
    oprintf("free models\n");
    if ((bspMem->availHeaders & freeType & LUMP_MODELS))
      tfree(bspMem->dmodels);

    oprintf("free entities\n");
    if ((bspMem->availHeaders & freeType & MAP_ENTITIES)) {
      struct entity *ent;
      int i;

      for (i = 0, ent = bspMem->mapentities; i < bspMem->nummapentities; i++, ent++) {
	struct epair *ep = ent->epairs;
	struct mbrush *mbr = ent->brushes;

	while (ep) {
	  struct epair *en = ep->next;

	  tfree(ep->key);
	  tfree(ep->value);
	  tfree(ep);
	  ep = en;
	}
	while (mbr) {
	  struct mbrush *mbn = mbr->next;
	  struct mface *mfc = mbr->faces;

	  while (mfc) {
	    struct mface *mfn = mfc->next;

	    tfree(mfc);
	    mfc = mfn;
	  }
	  tfree(mbr);
	  mbr = mbn;
	}
      }
      tfree(bspMem->mapentities);
    }
    oprintf("free texstrings\n");
    if ((bspMem->availHeaders & freeType & MAP_TEXSTRINGS))
      tfree(bspMem->maptexstrings);
    oprintf("free brushfaces\n");
    if ((bspMem->availHeaders & freeType & MAP_BRUSHFACES))
      tfree(bspMem->brushfaces);
    oprintf("free brushmaps\n");
    if ((bspMem->availHeaders & freeType & MAP_BRUSHPLANES))
      tfree(bspMem->brushplanes);

    /*
     * probably this is not ours;
     * tfree(bspMem);
     */
  }
  bspMem->availHeaders &= ~freeType;
}
