#ifndef	MAP_H
#define	MAP_H
/*
 * ============================================================================
 * structures
 * ============================================================================
 */

#define	MAXTOKEN		128
#define	SAVE_BACK		1024

#define MAX_MAPLIGHTLEVEL	300

struct plane {
  vec3_t normal;
  vec_t dist;
  int type;
} __packed;				// 20

struct mface {
  struct mface *next;
  struct plane plane;
  int texinfo;
  /* added by niels */
  vec3_t p0, p1, p2;
} __packed;				// 48 -> 96

struct mbrush {
  struct mbrush *next;
  struct mface *faces;
} __packed;				// 8

struct epair {
  struct epair *next;
  char *key;
  char *value;
} __packed;				// 12

struct entity {
  vec3_t origin;
  struct mbrush *brushes;
  struct epair *epairs;
  
  /* light */
  char *classname;
  float angle;
  int light, style;
  char *target, *targetname;
  struct entity *targetent;
} __packed;				// 20

/*
 * ============================================================================
 * globals
 * ============================================================================
 */

extern char token[MAXTOKEN];
extern bool unget;
extern char *script_p;
extern int scriptline;

/*
 * ============================================================================
 * prototypes
 * ============================================================================
 */

int FindMiptex(__memBase, char *name);
int FindTexinfo(__memBase, struct texinfo *t);
int MakeTexinfo (__memBase, char *texname, struct mface *f, float *scale, float rotate, float *shift);
struct entity *FindEntityWithKeyPair(__memBase, char *key, char *value);
struct entity *FindTargetEntity(__memBase, char *target);
struct entity *FindEntityWithModel(__memBase, int modnum);
void StartTokenParsing(char *data);
bool GetToken(bool crossline);
void UngetToken(void);
void ParseEpair(void);
void TextureAxisFromPlane(struct plane *pln, vec3_t xv, vec3_t yv);
void ParseBrush(__memBase);
bool ParseEntity(__memBase);
int LightStyleForTargetname(char *targetname, bool alloc);
void MatchTargets(__memBase);
void WriteEntitiesToString(__memBase);
void PrintEntity(struct entity *ent);
char *ValueForKey(struct entity *ent, char *key);
char *ValueForKeyN(struct entity * ent, char *key);
void SetKeyValue(struct entity *ent, char *key, char *value);
float FloatForKey(struct entity *ent, char *key);
float FloatForKeyN(struct entity *ent, char *key);
void GetVectorForKey(struct entity *ent, char *key, vec3_t vec);
#endif
