#ifndef	GRAPHICS_H
#define	GRAPHICS_H
#include "script.h"

/*
 * ============================================================================
 * structures
 * ============================================================================
 */

struct palpic {
  char *name;
  short int width, height;
  struct rgb *palette;
  unsigned char rawdata[0];
} __packed;

struct rawpic {
  char *name;
  short int width, height;
  struct rgb rawdata[0];
} __packed;

struct lump {
  int width, height;
  unsigned char rawdata[0];
} __packed;

/*
 * ============================================================================
 * globals
 * ============================================================================
 */

extern bool dither;
extern short int dithervalue;
extern bool smoothing;
extern short int smoothingvalue;

/*
 * ============================================================================
 * prototypes
 * ============================================================================
 */

bool RemapPalettes(unsigned char *dataBody, int dataSize, struct rgb *oldPalette, struct rgb *newPalette);
struct palpic *GetImage(FILE *file, char *picName, short int alignX, short int alignY);
bool PutImage(FILE *file, struct palpic *Picture, filetype picType);
#endif
