#ifndef	CRC_H
#define	CRC_H

#define CRC_INIT_VALUE	0xffff
#define CRC_XOR_VALUE	0x0000

extern unsigned short int crctable[256];

static void CRC_Init(unsigned short int *crcvalue);
static void CRC_ProcessByte(unsigned short int *crcvalue, unsigned char data);
static unsigned short int CRC_Value(unsigned short int crcvalue);

static inline void CRC_Init(unsigned short int *crcvalue) {
  *crcvalue = CRC_INIT_VALUE;
}

static inline void CRC_ProcessByte(unsigned short int *crcvalue, unsigned char data) {
  *crcvalue = (*crcvalue << 8) ^ crctable[(*crcvalue >> 8) ^ data];
}

static inline unsigned short int CRC_Value(unsigned short int crcvalue) {
  return crcvalue ^ CRC_XOR_VALUE;
}
#endif
