#ifndef	BSP_H
#define	BSP_H
/*
 * ============================================================================
 * structures
 * ============================================================================
 */

/* upper design bounds */
#define	MAX_MAP_HULLS		4
#define	MAX_HULL_POINTS		32
#define	MAX_HULL_EDGES		64

#define BSP_VERSION		29

struct dmodel_t {
  float mins[3], maxs[3];
  float origin[3];
  int headnode[MAX_MAP_HULLS];
  /* not including the solid leaf 0 */
  int visleafs;
  int firstface, numfaces;
};

struct dmiptexlump_t {
  int nummiptex;
  /* [nummiptex] */
  int dataofs[4];
};

struct dvertex_t {
  float point[3];
};

/* 0-2 are axial planes */
#define	PLANE_X			0
#define	PLANE_Y			1
#define	PLANE_Z			2

/* 3-5 are non-axial planes snapped to the nearest */
#define	PLANE_ANYX		3
#define	PLANE_ANYY		4
#define	PLANE_ANYZ		5

struct dplane_t {
  float normal[3];
  float dist;
  /* PLANE_X - PLANE_ANYZ ?remove? trivial to regenerate */
  int type;
};

#define	CONTENTS_EMPTY		-1
#define	CONTENTS_SOLID		-2
#define	CONTENTS_WATER		-3
#define	CONTENTS_SLIME		-4
#define	CONTENTS_LAVA		-5
#define	CONTENTS_SKY		-6

struct dnode_t {
  int planenum;
  /* negative numbers are -(leafs+1), not nodes */
  short int children[2];
  /* for sphere culling */
  short int mins[3];
  short int maxs[3];
  unsigned short int firstface;
  /* counting both sides */
  unsigned short int numfaces;
};

struct dclipnode_t {
  int planenum;
  /* negative numbers are contents */
  short int children[2];
};

struct texinfo {
  /* [s/t][xyz offset] */
  float vecs[2][4];
  int miptex;
  int flags;
};

/* sky or slime, no lightmap or 256 subdivision */
#define	TEX_SPECIAL		(1<<0)	/* aequivalent to 1 */
/* extensions to bsp-type added by niels */
#define	TEX_WATER		(1<<1)
#define	TEX_SLIME		(1<<2)
#define	TEX_LAVA		(1<<3)
#define	TEX_SKY			(1<<4)

/*
 * note that edge 0 is never used, because negative edge nums are used for
 * counterclockwise use of the edge in a face
 */
struct dedge_t {
  /* vertex numbers */
  unsigned short int v[2];
};

#define	MAXLIGHTMAPS		4
struct dface_t {
  short int planenum;
  short int side;
  /* we must support > 64k edges */
  int firstedge;
  short int numedges;
  short int texinfo;
  /* lighting info */
  unsigned char styles[MAXLIGHTMAPS];
  /* start of [numstyles*surfsize] samples */
  int lightofs;
};

#define	AMBIENT_WATER		0
#define	AMBIENT_SKY		1
#define	AMBIENT_SLIME		2
#define	AMBIENT_LAVA		3

/* automatic ambient sounds */
#define	NUM_AMBIENTS		4

/*
 * leaf 0 is the generic CONTENTS_SOLID leaf, used for all solid areas
 * all other leafs need visibility info
 */
struct dleaf_t {
  int contents;
  /* -1 = no visibility info */
  int visofs;
  /* for frustum culling */
  short int mins[3];
  short int maxs[3];
  unsigned short int firstmarksurface;
  unsigned short int nummarksurfaces;
  unsigned char ambient_level[NUM_AMBIENTS];
};

struct dpair {
  int offset, size;
};

struct bspheader {
  int version;
  struct dpair entities, planes, miptex, vertices, visilist
   ,nodes, texinfo, faces, lightmaps, clipnodes
   ,leaves, lface, edges, ledges, models;
};

struct visdata {
  char procName[32];
  int size;
};

/*
 * ============================================================================
 * bsp-tree related
 * ============================================================================
 */

// the exact bounding box of the brushes is expanded some for the headnode
// volume.  is this still needed?
#define	SIDESPACE			24

#define ON_EPSILON			0.05
#define	POINT_EPSILON			0.01
#define	DISTEPSILON			0.01
#define	T_EPSILON			0.01
#define	ZERO_EPSILON			0.001
#define CONTINUOUS_EPSILON		0.001
#define	ANGLEEPSILON			0.00001

#define BOGUS_RANGE			18000

#ifdef DYNAMIC_EDGES
struct visfacet {
  struct visfacet *next;
  int planenum;
  int planeside;							       // which side is the front of the face
  int texturenum;
  int contents[2];							       // 0 = front side
  struct visfacet *original;						       // face on node
  int outputnumber;							       // only valid for original faces after
  // write surfaces
  short int numpoints;
  vec3_t *pts;								       // FIXME: change to use winding_t
  int *edges;
} __packed;				// 36 + 384 + 128 = 548
#else
struct visfacet {
  struct visfacet *next;
  int planenum;
  int planeside;							       // which side is the front of the face
  int texturenum;
  int contents[2];							       // 0 = front side
  struct visfacet *original;						       // face on node
  int outputnumber;							       // only valid for original faces after
  // write surfaces
  //int numpoints;
  short int numpoints;							       // maximum is MAXEDGES
  vec3_t pts[MAXEDGES];							       // FIXME: change to use winding_t
  int edges[MAXEDGES];
} __packed;				// 36 + 384 + 128 = 548
					// 34 + 120 +  36 = 190
#endif

struct surface {
  struct surface *next;
  struct surface *original;						       // before BSP cuts it up
  int planenum;
  int outputplanenum;							       // only valid after WriteSurfacePlanes
  vec3_t mins, maxs;
  bool onnode;							       		// true if surface has already been used
  // as a splitting node
  struct visfacet *faces;						       // links to all the faces on either side of the surf
} __packed;				// 48

//
// there is a node_t structure for every node and leaf in the bsp tree
//
#define	PLANENUM_LEAF			-1

struct node {
  vec3_t mins, maxs;							       // bounding volume, not just points inside
// information for decision nodes
  int planenum;								       // -1 = leaf node
  int outputplanenum;							       // only valid after WriteNodePlanes
  int firstface;							       // decision node only
  int numfaces;								       // decision node only
  struct node *children[2];						       // only valid for decision nodes
  struct visfacet *faces;						       // decision nodes only, list for both sides
// information for leafs
  int contents;								       // leaf nodes (0 for decision nodes)
  struct visfacet **markfaces;						       // leaf nodes only, point to node faces
  struct portal *portals;
  int visleafnum;							       // -1 = solid
  int valid;								       // for flood filling
  //int occupied;							       // light number in leaf for outside filling
  short int occupied;							       // maximum in number of entities
} __packed;				// 76
					// 74

/*
 * ============================================================================
 * globals
 * ============================================================================
 */

/* light */
extern bool waterlit;
extern float scale, range;
/* qbsp */
extern bool watervis, slimevis;
extern bool nofill, notjunc, noclip, onlyents, usehulls;
extern int subdivide, hullnum;
/* vis */
extern bool fastvis;
extern int vislevel;

/*
 * ============================================================================
 * prototypes
 * ============================================================================
 */

#include "memory.h"

bool AddBSP(struct palpic *inPic, struct rawdata *inData, char *bspName, operation procOper, filetype inType);
bool ExtractBSP(FILE *file, FILE *script, char *destDir, char *entryName, filetype outType, operation procOper, bool recurse);
struct memory *LoadBSP(FILE *bspFile, int availLoad);
void WriteBSP(FILE *bspFile, __memBase);
#endif
