#ifndef	AMIGAOS_H
#define	AMIGAOS_H

#define	BASEWIDTH	80
#define	BASEHEIGHT	50
#define	MAXWIDTH	1280
#define	MAXHEIGHT	800

#ifdef LIBQSYS_DRIVER
#include <clib/alib_protos.h>
#include <inline/asl.h>
#include <inline/dos.h>
#include <inline/cybergraphics.h>
#include <inline/exec.h>
#include <inline/graphics.h>
#include <inline/intuition.h>
#include <inline/timer.h>

#include <cybergraphics/cybergraphics.h>				       // CyberGraphics display
#include <devices/input.h>
#include <devices/inputevent.h>
#include <devices/timer.h>
#include <dos/dos.h>							       // Lock()
#include <dos/dosextens.h>						       // Lock()
#include <exec/execbase.h>
#include <exec/interrupts.h>
#include <exec/memory.h>
#include <exec/nodes.h>
#include <exec/ports.h>
#include <exec/types.h>
#include <graphics/gfx.h>						       // BitMap funtions
#include <graphics/gfxbase.h>
#include <graphics/modeid.h>
#include <hardware/blit.h>
#include <intuition/screens.h>						       // OpenScreen()
#include <intuition/intuition.h>					       // OpenWindow()
#include <intuition/intuitionbase.h>
#include <libraries/asl.h>						       // ASLRequester
#include <utility/hooks.h>
#endif

#if defined(REPLACE_STDIO)
# include <inline/dos.h>
# include <dos/dos.h>
extern struct DOSBase *DOSBase;
# undef		 FILE
# define	 FILE BPTR
# undef 	 READ_BINARY
# define	 READ_BINARY MODE_OLDFILE
# undef 	 WRITE_BINARY
# define	 WRITE_BINARY MODE_NEWFILE
# undef 	 READ_BINARY_NEW
# define	 READ_BINARY_NEW MODE_READWRITE
# undef 	 WRITE_BINARY_NEW
# define	 WRITE_BINARY_NEW MODE_READWRITE
# undef 	 SEEK_SET
# define	 SEEK_SET OFFSET_BEGINNING
# undef 	 SEEK_CUR
# define	 SEEK_CUR OFFSET_CURRENT
# undef 	 SEEK_END
# define	 SEEK_END OFFSET_END
# undef 	 fopen
# define	 fopen(name, mode) Open(name, mode)
# undef 	 fclose
# define	 fclose(handle) Close(handle)
# undef 	 fread
# define	 fread(buffer, length1, length2, handle) Read(handle, buffer, length1 * length2)
# undef 	 fwrite
# define	 fwrite(buffer, length1, length2, handle) Write(handle, buffer, length1 * length2)
# undef 	 fseek
# define	 fseek(handle, position, mode) Seek(handle, position, mode)
#endif

#if defined(REPLACE_MEMPOOLS)
# include <inline/exec.h>
# include <exec/memory.h>
extern struct ExecBase *SysBase;
extern void *__memPool;
# undef		malloc
# define	malloc(size) AllocVecPooled(__memPool, size);
# undef		free
# define	free(ptr) FreeVecPooled(__memPool, ptr);
#endif

#define	OPENDISPLAY
#define	SWAPDISPLAY
#define	UPDATEDISPLAY
#define	CHANGEDISPLAY
#define	CLOSEDISPLAY

#define	OPENKEYS
#define	GETKEYS
#define	CLOSEKEYS

/*
 * ============================================================================
 * structures
 * ============================================================================
 */

/*
 * ============================================================================
 * globals
 * ============================================================================
 */

/*
 * ============================================================================
 * prototypes
 * ============================================================================
 */

#endif
