#ifndef TEXTURE_H
#define TEXTURE_H
#include "poly.h"
#include "surface.h"

#define	DENSITY_WATER	50
#define	DENSITY_SLIME	75
#define	DENSITY_LAVA	90
extern unsigned char *waterTransparency;	// 50
extern unsigned char *slimeTransparency;	// 75
extern unsigned char *lavaTransparency;		// 90
extern unsigned char *preTransparency;		// 
#define	watertransp(x, y)	(waterTransparency[(((int)(y)) << 8) + ((int)(x))])
#define	slimetransp(x, y)	(slimeTransparency[(((int)(y)) << 8) + ((int)(x))])
#define	lavatransp(x, y)	(lavaTransparency[(((int)(y)) << 8) + ((int)(x))])
#define	pretransp(x, y)		(preTransparency[(((int)(y)) << 8) + ((int)(x))])

#ifdef	FAST_WARP
extern int *swim_u, *swim_v, swim_phase;
extern int swim_u0[WARP_X >> MIPMAP_0], swim_v0[WARP_X >> MIPMAP_0];
extern int swim_u1[WARP_X >> MIPMAP_1], swim_v1[WARP_X >> MIPMAP_1];
extern int swim_u2[WARP_X >> MIPMAP_2], swim_v2[WARP_X >> MIPMAP_2];
extern int swim_u3[WARP_X >> MIPMAP_3], swim_v3[WARP_X >> MIPMAP_3];
extern int *swim_um[MIPMAP_MAX];
extern int *swim_vm[MIPMAP_MAX];
#endif

extern unsigned char *texture;
extern int textureMask1, textureMask2;
extern int textureRow;
extern short int textureShift1, textureShift2;
extern short int textureMip;
extern short int textureType;

short int compute_mip_level(__memBase, int face);
void compute_texture_gradients(__memBase, struct texture *Text, short int mip);
void draw_span(int y, int sx, int ex);
void update_water(void);

#endif
