#define	LIBQDISPLAY_CORE
#include "../include/libqdisplay.h"

float sinTable[MAX_ANGLE + 1], cosTable[MAX_ANGLE + 1];

void InitSinCosTables(void) {
  short int countFlow;
  double piFlow;
  float *sinFlow = &sinTable[MAX_ANGLE] + 1;
  float *cosFlow = &cosTable[MAX_ANGLE] + 1;

  for (countFlow = MAX_ANGLE, piFlow = MAX_ANGLE * M_PI / 180; countFlow >= 0; countFlow--, piFlow -= M_PI / 180) {
    *--sinFlow = sin(piFlow);
    *--cosFlow = cos(piFlow);
  }
};

int multTMap[MAX_MULTX][MAX_MULTY];
bool multDone = FALSE;
int *multMuls = &multTMap[0][0];
int *multRows = 0;

void InitMultTables(int width, int height) {
  int *lmulTables;
  short int i, j;
  int maxX;
  
  if(!multDone) {
    lmulTables = &multTMap[MAX_MULTX - 1][MAX_MULTY - 1] + 1;
    maxX = (MAX_MULTX - 1) * (MAX_MULTY - 1);

    for(i = MAX_MULTX - 1; i >= 0; i--) {
      int maxY = maxX;
    
      for(j = MAX_MULTY - 1; j >= 0; j--) {
        *--lmulTables = maxY;
        maxY -= (int)i;
      }
      maxX -= MAX_MULTY - 1;
    }
    multDone = TRUE;
  }
 
  if(multRows)
    tfree(multRows);
  if((multRows = (int *)tmalloc(sizeof(int) * (height + 1)))) {
    lmulTables = multRows + height + 1;
    
    for(i = height, maxX = width * height; i >= 0; i--, maxX -= width)
      *--lmulTables = maxX;
  }
  else
    Error("failed to allocate multiplication-tables\n");
};

/*
unsigned char *cachedTransparency = 0;
char cachedTransTemplate[] = "TArray.%2d";
char cachedTransName[] = "TArray.??";

void getTransparency(int transVal) {
  FILE *cachedTransFile;
  sprintf(cachedTransName, cachedTransTemplate, transVal);
  
  if(!cachedTransparency)
    if(!(cachedTransparency = (unsigned char *)tmalloc(256 * 256 * sizeof(unsigned char))))
      Error("failed to allocate transparency\n");
  
  mprintf("build transparency for density %2d\n", transVal);
  if(!(cachedTransFile = fopen(cachedTransName, READWRITE_BINARY_OLD))) {
    int i, j;
    struct rgb *actPel;
    
    for (i = 0; i < 256; i++) {
      actPel = &cachedPalette[i];
      for (j = 0; j < 256; j++) {
        int R, G, B;
        struct rgb matchPel;
        
        R = ((((int)(cachedPalette[j].r - actPel->r) * transVal) / 100) + (int)actPel->r);
        G = ((((int)(cachedPalette[j].g - actPel->g) * transVal) / 100) + (int)actPel->g);
        B = ((((int)(cachedPalette[j].b - actPel->b) * transVal) / 100) + (int)actPel->b);
        
        matchPel.r = (unsigned char)R;
        matchPel.g = (unsigned char)G;
        matchPel.b = (unsigned char)B;
        cachedTransparency[(i << 8) + j] = Match(&matchPel, cachedPalette);
      }
      mprogress(256, i + 1);
    }
    if((cachedTransFile = fopen(cachedTransName, WRITE_BINARY))) {
      fwrite(cachedTransparency, 256, 256, cachedTransFile);
      fclose(cachedTransFile);
    }
  }
  else {
    fread(cachedTransparency, 256, 256, cachedTransFile);
    fclose(cachedTransFile);
  }
}
 */
