#ifndef RENDER_H
#define RENDER_H
#include "3d.h"

extern int type;
extern int model;

extern unsigned char *visibleFaces;	//[MAX_MAP_FACES / 8 + 1];
extern unsigned char *visibleLeafs;	//[MAX_MAP_LEAFS / 8 + 1];
extern unsigned char *visibleNodes;	//[MAX_MAP_NODES];

#define is_marked_leaf(x)	(visibleLeafs[(x) >> 3] &   (1 << ((x) & 7)))
#define is_marked_node(x)	(visibleNodes[(x) >> 3] &   (1 << ((x) & 7)))
#define is_marked_face(x)	(visibleFaces[(x)])
#define mark_leaf(x)		(visibleLeafs[(x) >> 3] |=  (1 << ((x) & 7)))
#define mark_node(x)		(visibleNodes[(x) >> 3] |=  (1 << ((x) & 7)))
#define mark_face(x)		(visibleFaces[(x)] = contents)
#define unmark_leaf(x)		(visibleLeafs[(x) >> 3] &= ~(1 << ((x) & 7)))
#define unmark_node(x)		(visibleNodes[(x) >> 3] &= ~(1 << ((x) & 7)))
#define unmark_face(x)		(visibleFaces[(x)] = 0)

int leaf_in_frustrum(struct dleaf_t * node);
void mark_leaf_faces(__memBase, int leaf);
int node_in_frustrum(struct dnode_t * node);
void render_node_faces(__memBase, int node, int side);
void render_world(__memBase);
int visit_visible_leaves(__memBase);

#endif
