#define	LIBQTOOLS_CORE
#define	LIBQDISPLAY_CORE
#include "../include/libqdisplay.h"
#include "../include/libqsys.h"

struct memory bspStatic;
struct memory *bspMem = &bspStatic;

int frameCounter;

#ifdef CALCULATE_PIXELDRAW
int pixelDraw;
int pixelOverdraw;
#endif

void run_demo(__memBase)
{
  angvec lastCamera = {0, 0, 0};

#ifdef PROFILE
  for (frameCounter = 0; frameCounter < 10; frameCounter++) {
#else
  int updownHeight, leftrightWidth;
  float updownAngles, leftrightAngles;
  int flyMode = FALSE;
  struct keyEvent inPut;
  
  for (frameCounter = 0;; frameCounter++) {
#endif
   /*
    * first verify the validity of the display and the renderers informations
    */
    if(localDim.changedBuffer) {							// changedSize need not implicate changeBuffer
      InitMultTables(localDim.Width, localDim.Height);
      set_clip_values(localDim.Width, localDim.Height);
      localDim.changedBuffer = FALSE;
      changedAngles = TRUE;
    }
    if(localDim.changedOffset || localDim.changedSize) {
      if(flyMode) {
        cameraAngles.tx = (int)((localDim.X - updownHeight) * updownAngles);
        cameraAngles.tz = (int)((localDim.Y - leftrightWidth) * leftrightAngles);
        changedAngles = TRUE;
      }
      if(localDim.changedSize) {
        updownHeight = (localDim.dtHeight - localDim.Height) / 2;
        leftrightWidth = (localDim.dtWidth - localDim.Width) / 2;
        updownAngles = 90.0 / updownHeight;
        leftrightAngles = 180.0 / leftrightWidth;
      }
      localDim.changedOffset = FALSE;
      localDim.changedSize = FALSE;
    }
    if(localDim.changedDesktopOffset) {
      localDim.changedDesktopOffset = FALSE;
    }
    if(localDim.changedDesktopSize) {
      updownHeight = (localDim.dtHeight - localDim.Height) / 2;
      leftrightWidth = (localDim.dtWidth - localDim.Width) / 2;
      updownAngles = 90.0 / updownHeight;
      leftrightAngles = 180.0 / leftrightWidth;
      localDim.changedDesktopSize = FALSE;
    }

   /*
    * recalc renderer if nessecary and render and display
    */
    set_view_info();
    memset(localDim.frameBuffer, 0, localDim.frameSize);
    render_world(bspMem);
    localDim.frameBuffer = SwapDisplay(localDim.frameBuffer);

#ifdef CALCULATE_PIXELDRAW
    memset(localDim.frameBuffer, 0, localDim.frameSize);
    mprintf("draw pixel: %d, overdrawn pixel: %d\n", pixelDraw, pixelOverdraw);
    pixelDraw = pixelOverdraw = 0;
#endif
#ifndef PROFILE
   /*
    * parse inputevents, this is also the only way to communicate 
    * with the user-interface, if the display changes, verify it in
    * that routine
    */
    while(GetKeys(&inPut)) {
      if(inPut.pressed == RAWKEY_NOTHING)
        break;

      switch(inPut.pressed) {
        case RAWKEY_ESCAPE:
        case RAWKEY_q:
          return;
          break;

        case RAWKEY_NUMPAD_PGDN:
          cameraAngles.tx += (inPut.qualifier == RAWQUAL_RSHIFT ? 20 : 10);
          changedAngles = TRUE;
          break;
        case RAWKEY_NUMPAD_PGUP:
          cameraAngles.tx -= (inPut.qualifier == RAWQUAL_RSHIFT ? 20 : 10);
          changedAngles = TRUE;
          break;
        case RAWKEY_NUMPAD_HOME:
          currentSpeed[2] += (inPut.qualifier == RAWQUAL_RSHIFT ? 2 * incSpeed : incSpeed);
          changedLocation = TRUE;
          break;
        case RAWKEY_NUMPAD_END:
          currentSpeed[2] -= (inPut.qualifier == RAWQUAL_RSHIFT ? 2 * incSpeed : incSpeed);
          changedLocation = TRUE;
          break;
        case RAWKEY_NUMPAD_AWUP:
          currentSpeed[0] += (inPut.qualifier == RAWQUAL_RSHIFT ? 2 * incSpeed : incSpeed);
          changedLocation = TRUE;
          break;
        case RAWKEY_NUMPAD_AWDN:
          currentSpeed[0] -= (inPut.qualifier == RAWQUAL_RSHIFT ? 2 * incSpeed : incSpeed);
          changedLocation = TRUE;
          break;
        case RAWKEY_NUMPAD_AWRIGHT:
          cameraAngles.tz += (inPut.qualifier == RAWQUAL_RSHIFT ? 20 : 10);
          changedAngles = TRUE;
          break;
        case RAWKEY_NUMPAD_AWLEFT:
          cameraAngles.tz -= (inPut.qualifier == RAWQUAL_RSHIFT ? 20 : 10);
          changedAngles = TRUE;
          break;
        case RAWKEY_NUMPAD_PLUS:
          cameraAngles.ty += (inPut.qualifier == RAWQUAL_RSHIFT ? 20 : 10);
          changedAngles = TRUE;
          break;
        case RAWKEY_NUMPAD_MINUS:
          cameraAngles.ty -= (inPut.qualifier == RAWQUAL_RSHIFT ? 20 : 10);
          changedAngles = TRUE;
          break;
        case RAWKEY_f:
          if((flyMode ^= TRUE) == TRUE)
            currentSpeed[0] = currentSpeed[2] = (maxSpeed / 3);
          else
            currentSpeed[2] = -(maxSpeed / 3);
          changedLocation = TRUE;
          break;
      }
    }

    /*
     * validate input events
     */
    if(flyMode) {
      if(cameraAngles.tz - lastCamera.tz) {
        cameraAngles.ty -= (cameraAngles.tz - lastCamera.tz) / 4;
        changedAngles = TRUE;
      }
      currentSpeed[0] += decSpeed;
      changedLocation = TRUE;
    }
    
    if(changedAngles) {
      if (cameraAngles.tx > 360)
        cameraAngles.tx -= 360;
      else if (cameraAngles.tx < 0)
        cameraAngles.tx += 360;

      if (cameraAngles.ty > 360)
        cameraAngles.ty -= 360;
      else if (cameraAngles.ty < 0)
        cameraAngles.ty += 360;
      if ((cameraAngles.ty > 45) && (cameraAngles.ty < 180))
        cameraAngles.ty = 45;
      else if ((cameraAngles.ty < 315) && (cameraAngles.ty > 180))
        cameraAngles.ty = 315;
      
      if (cameraAngles.tz > 360)
        cameraAngles.tz -= 360;
      else if (cameraAngles.tz < 0)
        cameraAngles.tz += 360;

      lastCamera.tz = cameraAngles.tz;
    }

    if(changedLocation) {        
      if (currentSpeed[0] >= maxSpeed)
        currentSpeed[0] = maxSpeed;
      else if (currentSpeed[0] <= -maxSpeed)
        currentSpeed[0] = -maxSpeed;

      if (currentSpeed[2] >= maxSpeed)
        currentSpeed[2] = maxSpeed;
      else if (currentSpeed[2] <= -maxSpeed)
        currentSpeed[2] = -maxSpeed;
    }
#else
    switch(frameCounter) {
      case 0:
	      if ((cameraAngles.tx += 25) > 360)
		cameraAngles.tx -= 360;
	      changedAngles = TRUE;
        break;
      case 1:
	      if ((cameraAngles.tx += 25) > 360)
		cameraAngles.tx -= 360;
	      changedAngles = TRUE;
        break;
      case 2:
	      if ((cameraAngles.tx -= 75) < 0)
		cameraAngles.tx += 360;
	      changedAngles = TRUE;
        break;
      case 3:
	      if ((cameraAngles.tx -= 25) < 0)
		cameraAngles.tx += 360;
	      changedAngles = TRUE;
        break;
      case 4:
	      if ((cameraAngles.tx += 50) > 360)
		cameraAngles.tx -= 360;
	      changedAngles = TRUE;
        break;
      case 5:
	      if ((cameraAngles.tz += 25) > 360)
		cameraAngles.tz -= 360;
	      changedAngles = TRUE;
        break;
      case 6:
	      if ((cameraAngles.tz += 25) > 360)
		cameraAngles.tz -= 360;
	      changedAngles = TRUE;
        break;
      case 7:
	      if ((cameraAngles.tz += 25) > 360)
		cameraAngles.tz -= 360;
	      changedAngles = TRUE;
        break;
      case 8:
	      if ((cameraAngles.tz += 25) > 360)
		cameraAngles.tz -= 360;
	      changedAngles = TRUE;
        break;
      case 9:
	      if ((cameraAngles.tz += 25) > 360)
		cameraAngles.tz -= 360;
	      changedAngles = TRUE;
        break;
    }
#endif
  }
}

int main(int argc, char **argv)
{
  FILE *bspFile;

  if (!setjmp(eabort)) {
    if((bspFile = fopen(argv[1], READWRITE_BINARY_OLD))) {
      if((bspMem = LoadBSP(bspFile, ALL_LUMPS | ALL_MAPS))) {
        struct entity *plEnt;
      
        bspMem->mapOptions |= MAP_LOADLIGHTS;
        LoadMapFile(bspMem, bspMem->dentdata);
        if(!(visibleFaces = (unsigned char *)kmalloc((bspMem->numfaces + 32) * sizeof(unsigned char))))
          Error("failed to allocate visible faces\n");
        if(!(visibleLeafs = (unsigned char *)kmalloc(((bspMem->numleafs >> 3) + 32) * sizeof(unsigned char))))
          Error("failed to allocate visible leafs\n");
        memset(visibleLeafs, 0xFF, ((bspMem->numleafs >> 3) + 1) * sizeof(unsigned char));
        if(!(visibleNodes = (unsigned char *)kmalloc(((bspMem->numnodes >> 3) + 32) * sizeof(unsigned char))))
          Error("failed to allocate visible nodes\n");
        memset(visibleNodes, 0xFF, ((bspMem->numnodes >> 3) + 1) * sizeof(unsigned char));
        
        /*
         * find players start-point
         */
        if((plEnt = FindEntityWithKeyPair(bspMem, "classname", "info_player_start"))) {
          VectorCopy(plEnt->origin, cameraLocation);
	  cameraAngles.tx = 0;
	  cameraAngles.ty = 0;
          cameraAngles.tz = plEnt->angle;
          printf("Current Pos - [%f] [%f] [%f]\nAngle [%d]\n", cameraLocation[0], cameraLocation[1], cameraLocation[2], cameraAngles.tz);
          changedAngles = TRUE;
          changedLocation = TRUE;
        }
        
        /*
         * force load of palette and colormap
         */
        darkness = 63;
        tfree(GetPalette());
        
        if(cachedColormap && cachedPalette) {
//mprintf("set display\n");
          SetDisplay(OpenDisplay(atoi(argv[2]), atoi(argv[3]), 8, cachedPalette));
          OpenKeys();
          
//mprintf("set water\n");
          // setup water
          waterTransparency = GetTransparency(DENSITY_WATER);
//mprintf("set slime\n");
          // setup slime
          slimeTransparency = GetTransparency(DENSITY_SLIME);
//mprintf("set lava\n");
          // setup lava
          lavaTransparency = GetTransparency(DENSITY_LAVA);
        
//mprintf("clear buffer\n");
          memset(localDim.frameBuffer, 0, localDim.frameSize);
//mprintf("swap display\n");
          localDim.frameBuffer = SwapDisplay(localDim.frameBuffer);
//mprintf("display colormap\n");
          UpdateDisplay(cachedColormap, 0, 0, 256, 64);
//mprintf("display water\n");
          UpdateDisplay(waterTransparency, 0, 0, 256, 256);
//mprintf("display slime\n");
          UpdateDisplay(slimeTransparency, 0, 0, 256, 256);
//mprintf("display lava\n");
          UpdateDisplay(lavaTransparency, 0, 0, 256, 256);
          
//mprintf("init sin/cos\n");
          InitSinCosTables();
//mprintf("inint face-cache\n");
          InitFaceCache(bspMem);
//mprintf("set point list\n");
          setup_default_point_list();
          
          run_demo(bspMem);
          
          CloseKeys();
          CloseDisplay();
        }
        
        FreeClusters(bspMem, 0);
        kfree();
      }
      fclose(bspFile);
    }
  }

  return 0;
}
