#ifndef D3_H
#define	D3_H
#include "vesa.h"
#include "main.h"
#include "tables.h"

/*
 * ============================================================================
 * structures
 * ============================================================================
 */

#define CC_OFF_LEFT    1
#define CC_OFF_RIGHT   2
#define CC_OFF_TOP     4
#define CC_OFF_BOT     8
#define CC_BEHIND      16
#define WALL_TYPE	(~CONTENTS_SOLID)	// -2
#define WATER_TYPE	(~CONTENTS_WATER)	// -3
#define SLIME_TYPE	(~CONTENTS_SLIME)	// -4
#define LAVA_TYPE	(~CONTENTS_LAVA)	// -5
#define SKY_TYPE	(~CONTENTS_SKY)		// -6
#define TELEPORT_TYPE	(~(-7))
#define OTHER_TYPE	(~(-8))
#define ANIM_TYPE	(~(-9))

//#define	FIX_INT(x)	(((x) + 32768) >> 16)
//#define	FLOAT_TO_INT(x)	((int)((x) + 0.5))
//#define	FLOAT_TO_FIX(x)	(FLOAT_TO_INT(scalw((x), 16)))
#define	FIX_INT(x)	(((x) + 65535) >> 16)
#define	FLOAT_TO_INT(x)	((int)(x))
#define	FLOAT_TO_FIX(x)	((int)((x) * 65536))

typedef int fix;

typedef struct {
  int tx, ty, tz;
} angvec;

typedef struct {
  vec3_t p;
  unsigned char ccodes;
  unsigned char pad0, pad1, pad2;
  fix sx, sy;
  float u, v;
} point_3d;

/*
 * ============================================================================
 * globals
 * ============================================================================
 */

extern float clipScaleX, clipScaleY, incSpeed, maxSpeed, decSpeed;
extern vec3_t cameraLocation, currentSpeed, old_cam_loc;
extern bool changedLocation, changedAngles;
extern angvec cameraAngles;
extern struct dplane_t planes[4];
extern float xCenter, yCenter;

/*
 * ============================================================================
 * prototypes
 * ============================================================================
 */

void compute_view_frustrum(void);
float dist2_from_viewer(vec_t *in);
void init_tables(void);
void set_clip_values(int width, int height);
void set_view_info(void);
void transform_point(point_3d * p, vec_t *v);
void transform_point_raw(vec_t *out, vec_t *in);
void transform_rotated_point(point_3d * p);
void transform_vector(vec_t *out, vec_t *in);

#endif
