#define	LIBQBUILD_CORE
#include "../include/libqbuild.h"
#include <gl/gl.h>
#include <gl/glu.h>
#include <gl/gltk.h>
#include <gl/glaux.h>

vec3_t draw_mins, draw_maxs;

#define	WIN_SIZE	512

void Draw_Init(void)
{
  auxInitDisplayMode(AUX_SINGLE | AUX_RGB);
  auxInitPosition(0, 0, WIN_SIZE, WIN_SIZE);
  auxInitWindow("qcsg");
}

void Draw_Exit(void)
{
  auxCloseWindow();
  auxQuit();
}

void Draw_ClearBounds(void)
{
  if(drawflag == TRUE) {
  }
}

void Draw_AddToBounds(vec3_t v)
{
  if(drawflag == TRUE) {
  }
}

void Draw_DrawFace(struct visfacet * f)
{
  if(drawflag == TRUE) {
    int i;

    glColor4f(0, 0, 0, 0.5);
    glBegin(GL_LINE_LOOP);
    for (i = 0; i < f->numpoints; i++)
      glVertex3f(f->pts[i][0], f->pts[i][1], f->pts[i][2]);
    glEnd();

    glColor4f(0, 1, 0, 0.3);
    glBegin(GL_POLYGON);
    for (i = 0; i < f->numpoints; i++)
      glVertex3f(f->pts[i][0], f->pts[i][1], f->pts[i][2]);
    glEnd();

    glFlush();
  }
}

void Draw_ClearWindow(void)
{
  if(drawflag == TRUE) {
    int w, h, g;
    vec_t mx, my;

    glClearColor(1, 0.8, 0.8, 0);
    glClear(GL_COLOR_BUFFER_BIT);

    w = (draw_maxs[0] - draw_mins[0]);
    h = (draw_maxs[1] - draw_mins[1]);

    mx = draw_mins[0] + w / 2;
    my = draw_mins[1] + h / 2;

    g = w > h ? w : h;

    glLoadIdentity();
    gluPerspective(90, 1, 2, 16384);
    gluLookAt(mx, my, draw_maxs[2] + g / 2, mx, my, draw_maxs[2], 0, 1, 0);

    glColor3f(0, 0, 0);
//  glPolygonMode (GL_FRONT_AND_BACK, GL_LINE);
    glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
    glDisable(GL_DEPTH_TEST);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

#if 0
    glColor4f(1, 0, 0, 0.5);
    glBegin(GL_POLYGON);

    glVertex3f(0, 500, 0);
    glVertex3f(0, 900, 0);
    glVertex3f(0, 900, 100);
    glVertex3f(0, 500, 100);

    glEnd();
#endif

    glFlush();
  }
}

void Draw_SetRed(void)
{
  if(drawflag == TRUE) {
    glColor3f(1, 0, 0);
  }
}

void Draw_SetGrey(void)
{
  if(drawflag == TRUE) {
    glColor3f(0.5, 0.5, 0.5);
  }
}

void Draw_SetBlack(void)
{
  if(drawflag == TRUE) {
    glColor3f(0, 0, 0);
  }
}

void DrawPoint(vec3_t v)
{
  if(drawflag == TRUE) {
    glColor4f(0, 0.5, 0.5, 0.5);
    glBegin(GL_POINTS);
    glVertex3f(v[0], v[1], v[2]);
    glEnd();

    glFlush();
  }
}

void DrawLeaf(struct node * l, int color)
{
}

void DrawBrush(struct brush * b)
{
  if(drawflag == TRUE) {
  }
}

void DrawWinding(struct winding * w)
{
  if(drawflag == TRUE) {
    int i;

    glColor4f(0, 0, 0, 0.5);
    glBegin(GL_LINE_LOOP);
    for (i = 0; i < w->numpoints; i++)
      glVertex3f(w->p[i][0], w->p[i][1], w->p[i][2]);
    glEnd();

    glColor4f(0, 1, 0, 0.3);
    glBegin(GL_POLYGON);
    for (i = 0; i < w->numpoints; i++)
      glVertex3f(w->p[i][0], w->p[i][1], w->p[i][2]);
    glEnd();

    glFlush();
  }
}

void DrawTri(vec3_t p1, vec3_t p2, vec3_t p3)
{
  if(drawflag == TRUE) {
    glColor4f(0, 0.5, 0, 0.5);
    glBegin(GL_TRIANGLES);
    glVertex3f(p1[0], p1[1], p1[2]);
    glVertex3f(p2[0], p2[1], p2[2]);
    glVertex3f(p3[0], p3[1], p3[2]);
    glEnd();

    glFlush();
  }
}

void DrawPortal(struct portal * portal)
{
  if(drawflag == TRUE) {
  }
}
