#ifndef	BRUSH_H
#define	BRUSH_H

// brush.c

#define	NUM_HULLS	2						       // normal and +16
#define	NUM_CONTENTS	2						       // solid and water

struct brush {
  struct brush *next;
  vec3_t mins, maxs;
  struct visfacet *faces;
  int contents;
} __packed;

struct brushset {
  vec3_t mins, maxs;
  struct brush *brushes;							// NULL terminated list
  /* PROGRESS-ONLY! */
  int numbrushes;
} __packed;

//=============================================================================

struct brushset * Brush_LoadEntity(__memBase, struct entity * ent, int hullnum);
void CheckFace(__memBase, register struct visfacet * f);
int PlaneTypeForNormal(vec3_t normal);
int FindPlane(__memBase, register struct plane *dplane, register int *side);

#endif
