#ifndef	LIBQTOOLS_H
#define	LIBQTOOLS_H

#ifdef	HAVE_CONFIG_H
# include "./config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <stdarg.h>
#include <setjmp.h>
#ifdef HAVE_DIRENT_H
# include <dirent.h>
#endif

/*
 * ============================================================================
 */

#include "./libqsys.h"
#include "./mathlib.h"

#include "../libqtools/misc.h"
#include "../libqtools/graphics.h"
#include "../libqtools/raw.h"

#include "../libqtools/script.h"
#include "../libqtools/pak.h"
#include "../libqtools/wad.h"
#include "../libqtools/mip.h"
#include "../libqtools/bsp.h"
#include "../libqtools/memory.h"
#include "../libqtools/crc.h"

/*
 * ============================================================================
 */

#ifdef	LIBQTOOLS_CORE
#include "../libqtools/map.h"
#endif

#define	MAP_LOADLIGHTS		(1<<0)
#define	MAP_VERBOSE1		(1<<1)
#define	MAP_VERBOSE2		(1<<2)

bool LoadMapFile(__memBase, char *mapBuf);
bool SaveMapFile(__memBase, FILE *outFile);
bool LoadBSPFile(__memBase);

// ============================================================================

bool LoadTDDDFile(__memBase, char *tdddBuf);
bool SaveTDDDFile(__memBase, FILE * outFile);

// ============================================================================

#endif
