/*
 * Unwad2.c - Uses the routines in the QEU library to extract data
 *            from a Quake WAD2 file.
 *
 * Do whatever you want with this file, but don't blame me if
 * something doesn't work.  If you manage to destroy your hard disk
 * with it, that's too bad for you...  Use it at your own risks!
 */

#include "qeu.h"
#include "q_misc.h"
#include "q_files.h"
#include "f_wad2.h"

void main(int argc, char *argv[])
{
  char       *filename = NULL;
  FILE       *file;
  int         ftype;
  WAD2DirPtr  dir;
  UInt16      dirsize, n;
  Bool        view = FALSE;
  Bool        convert = FALSE;
  char       *dirname = NULL;

  /* read the parameters... */
  for (argv++, argc--; argc && **argv == '-'; argv++, argc--)
    if ((*argv)[1] == 'h')
      {
	fprintf(stderr, "UNWAD2 %s by Raphael Quinet\n\n", QEU_VERSION);
	fprintf(stderr, "Usage: unwad2 [-h] [-v] [-c] [-d <directory>] file.wad [entryname...]\n");
	fprintf(stderr, "       -h  -- display this help screen\n");
	fprintf(stderr, "       -v  -- view the contents of the wad file without extracting any data\n");
	fprintf(stderr, "       -c  -- convert bitmaps to BMP files when extracting\n");
	fprintf(stderr, "       -d  -- use the specified directory for extraction\n");
	fprintf(stderr, "By default, unwad2 will extract all entries from the wad file in a directory\n");
	fprintf(stderr, "which has the same name as the wad file but the extension '.dir'.  If some\n");
	fprintf(stderr, "names are given after the file name, only these entries will be extracted.\n");
	exit(1);
      }
    else if ((*argv)[1] == 'v')
      view = TRUE;
    else if ((*argv)[1] == 'c')
      convert = TRUE;
    else if ((*argv)[1] == 'd' && argc-- > 1)
      dirname = *++argv;
    else
      ProgError("Invalid argument (%s).  Use unwad2 -h for help.", *argv);
  if (argc > 0)
    filename = *argv;
  else
    ProgError("Missing argument.  Use unwad2 -h for help.");
  if (dirname == NULL)
    dirname = ChangeFileExtension(filename, NULL, "dir");

  /* open the WAD2 file... */
  file = OpenFileReadMagic(filename, &ftype);
  if (file == NULL)
    ProgError("File not found (%s)", filename);
  if (ftype != FTYPE_WAD2)
    ProgError("File is not a WAD2 file (%s)", filename);

  /* do something... */
  dir = ReadWAD2Directory(file, 0, &dirsize);
  if (dir == NULL)
    ProgError("Cannot read main directory from %s", filename);
  if (view == TRUE)
    DumpWAD2Directory(stdout, dir, dirsize);
  else if (argc > 1)
    for (argv++, argc--; argc; argv++, argc--)
      {
	n = FindWAD2Entry(dir, dirsize, *argv);
	if (n >= dirsize)
	  ProgError("Could not find entry %s in directory", *argv);
	if (UnWAD2File(stdout, file, 0, dir, dirsize, n, dirname,
		       convert) == FALSE)
	  ProgError("Could not unpack entry %s from %s", *argv, filename);
      }
  else
    if (UnWAD2File(stdout, file, 0, dir, dirsize, dirsize, dirname,
		   convert) == FALSE)
      ProgError("Could not unpack all entries from %s", filename);

  /* close the file and say goodbye */
  fclose(file);
  exit(0);
}
