/*
 * SprView.c - Uses the routines in the QEU library to extract data
 *             from a Quake sprite file.
 *
 * Do whatever you want with this file, but don't blame me if
 * something doesn't work.  If you manage to destroy your hard disk
 * with it, that's too bad for you...  Use it at your own risks!
 */

#include "qeu.h"
#include "q_misc.h"
#include "q_files.h"
#include "f_bitmap.h"
#include "f_sprite.h"

void main(int argc, char *argv[])
{
  char      *filename;
  FILE      *file;
  SpritePtr  sprite;
  int        ftype;

  argv++;
  argc--;
  if (argc != 1)
    ProgError("Usage: sprview <filename.spr>");
  filename = *argv;

  file = OpenFileReadMagic(filename, &ftype);
  if (file == NULL)
    ProgError("File not found (%s)", filename);
  if (ftype != FTYPE_SPRITE)
    ProgError("File is not a sprite file (%s)", filename);
  sprite = ReadSprite(file, 0L);
  fclose(file);
  DumpSprite(stdout, sprite);
  FreeSprite(sprite);
}
