/*
 * Repak.c - Uses the routines in the QEU library to re-create a
 *           Quake PACK file from a list of separate files.
 *
 * Do whatever you want with this file, but don't blame me if
 * something doesn't work.  If you manage to destroy your hard disk
 * with it, that's too bad for you...  Use it at your own risks!
 */

#include "qeu.h"
#include "q_misc.h"
#include "q_files.h"
#include "f_pack.h"

void main(int argc, char *argv[])
{
  char       *filename;
  FILE       *file;
  FILE       *srcfile;
  int         ftype;
  PACKDirPtr  dir;
  UInt16      dirsize;
  char       *indexname = NULL;
  UInt32      size, count;

  /* read the parameters... */
  for (argv++, argc--; argc && **argv == '-'; argv++, argc--)
    if ((*argv)[1] == 'h')
      {
	fprintf(stderr, "REPAK %s by Raphael Quinet\n\n", QEU_VERSION);
	fprintf(stderr, "Usage: repak [-h] [-i <indexfile>] file.pak [entryname...]\n");
	fprintf(stderr, "       -h  -- display this help screen\n");
	fprintf(stderr, "       -i  -- get the list of files from the specified index file\n");
	fprintf(stderr, "Repak will create a PACK file containing all the files specified on the\n");
	fprintf(stderr, "command line, or append them to the PACK file if it already exists\n");
	fprintf(stderr, "If the -i option is used, the list of files is read from the specified\n");
	fprintf(stderr, "index file (usually %s, as created by unpak).\n", QEU_INDEX_FILE);
	exit(1);
      }
    else if ((*argv)[1] == 'i' && argc-- > 1)
      indexname = *++argv;
    else
      ProgError("Invalid argument (%s).  Use repak -h for help.", *argv);
  if (argc <= 0)
    ProgError("Missing argument.  Use repak -h for help.");
  filename = *argv;
  if (indexname == NULL && argc < 2)
    ProgError("List of files missing.  Use repak -h for help.");

  /* check if the file exists */
  file = OpenFileReadMagic(filename, &ftype);
  if (file == NULL)
    {
      /* create a new PACK file */
      file = fopen(filename, "wb");
      if (file == NULL)
	ProgError("Cannot create file (%s)", filename);
      if (WritePACKHeader(file, &count, &dir, &dirsize) == FALSE)
	ProgError("Cannot write PACK file header");
    }
  else
    {
      /* append to an existing PACK file */
      if (ftype != FTYPE_PACK)
	ProgError("File is not a PACK file (%s)", filename);
      dir = ReadPACKDirectory(file, 0L, &dirsize);
      if (dir == NULL)
	ProgError("Cannot read main directory from %s", filename);
      /* re-open file for writing */
      fclose(file);
      file = fopen(filename, "r+b");
      count = dir[dirsize - 1].offset + dir[dirsize - 1].size;
      if (file == NULL || fseek(file, count, SEEK_SET) < 0)
	ProgError("Cannot re-open file for writing (%s)", filename);
    }

  /* parse the index file and read all the files listed in it */
  if (indexname != NULL)
    ProgError("Option -i not implemented yet.  Sorry...\n"); /*! missing */

  /* if there are extra arguments on the command line, read these files too */
  for (argv++, argc--; argc; argv++, argc--)
    {
      srcfile = fopen(*argv, "rb");
      if (srcfile == NULL)
	ProgError("File not found (%s)", *argv);
      size = GetFileSize(srcfile);
      printf("Copying %lu bytes from %s\n", size, *argv);
      if (CopyBytes(file, srcfile, size) == FALSE)
	ProgError("Cannot copy data");
      if (AddPACKEntry(file, &count, &dir, &dirsize, *argv, size) == FALSE)
	ProgError("Cannot register entry in PACK directory (%s)", *argv);
      fclose(srcfile);
    }

  /* write the directory */
  size = WritePACKDirectory(file, &count, dir, dirsize);
  if (size == 0L)
    ProgError("Cannot write PACK directory");
  printf("Total size of %s: %lu bytes\n", filename, size);

  /* close the file and say goodbye */
  fclose(file);
  exit(0);
}
