/*
 * Copyright (C) 1996 by Raphael Quinet.  All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation.  If more than a few
 * lines of this code are used in a program which displays a copyright
 * notice or credit notice, the following acknowledgment must also be
 * displayed on the same screen: "This product includes software
 * developed by Raphael Quinet for use in the Quake Editing Utilities
 * project."  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR
 * IMPLIED WARRANTY.
 *
 * More information about the QEU project can be found on the WWW:
 * "http://www.montefiore.ulg.ac.be/~quinet/games/editing.html" or by
 * mail: Raphael Quinet, 9 rue des Martyrs, B-4550 Nandrin, Belgium.
 */

#ifndef _Q_FILES_H_
#define _Q_FILES_H_
/*
 * Q_FILES.H - Basic file loading and saving routines.
 */

/* constants */
/*      file type             ext.  magic  */
#define FTYPE_UNKNOWN 0
#define FTYPE_IWAD    1    /* .wad  "IWAD" */
#define FTYPE_PWAD    2    /* .wad  "PWAD" */
#define FTYPE_PACK    3    /* .pak  "PACK" */
#define FTYPE_WAD2    4    /* .wad  "WAD2" */
#define FTYPE_BSP     10   /* .bsp  (0x17 0x00 0x00 0x00) */
#define FTYPE_MODEL   11   /* .mdl  "IDPO" */
#define FTYPE_SPRITE  12   /* .spr  "IDSP" */
#define FTYPE_WAV     20   /* .wav  "RIFF" */
#define FTYPE_AU      21   /* .au   ".snd" */
#define FTYPE_VOC     22   /* .voc  ?      */
#define FTYPE_PBM_ASC 30   /* .pbm  "P1"   */
#define FTYPE_PGM_ASC 31   /* .pgm  "P2"   */
#define FTYPE_PPM_ASC 32   /* .ppm  "P3"   */
#define FTYPE_PBM_RAW 33   /* .pbm  "P4"   */
#define FTYPE_PGM_RAW 34   /* .pgm  "P5"   */
#define FTYPE_PPM_RAW 35   /* .ppm  "P6"   */
#define FTYPE_BMP     36   /* .bmp  "BM"   */
#define FTYPE_GIF     37   /* .gif  "GIF8" */
#define FTYPE_PCX     38   /* .pcx  (0x0a 0x05 0x01 0x08) */
#define FTYPE_ERROR   -1

/* prototypes */
Bool  Exists(char *filename);
void  CreatePathToFile(char *filename);
char *ConvertFilePath(char *filename);
char *UNIXifyFilePath(char *filename);
char *GetBaseName(char *filename);
char *GetFileExtension(char *filename);
char *ChangeFileExtension(char *filename, char *oldext, char *newext);
Int32 GetFileSize(FILE *file);

Bool  ReadBytes(FILE *file, void huge *addr, UInt32 size);
Bool  WriteBytes(FILE *file, void huge *addr, UInt32 size);
Bool  CopyBytes(FILE *dest, FILE *source, UInt32 size);

int   ReadMagic(FILE *file);
FILE *OpenFileReadMagic(char *filename, int *ftype_r);

#ifdef FAT_ENDIAN
Bool ReadInt16(FILE *file, UInt16 huge *x);
Bool ReadInt32(FILE *file, UInt32 huge *x);
Bool ReadFloat32(FILE *file, Float32 huge *x);
Bool WriteInt16(FILE *file, UInt16 huge *x);
Bool WriteInt32(FILE *file, UInt32 huge *x);
Bool WriteFloat32(FILE *file, Float32 huge *x);
#else
#define ReadInt16(f, p)    ReadBytes((f), (p), 2L)
#define ReadInt32(f, p)    ReadBytes((f), (p), 4L)
#define ReadFloat32(f, p)  ReadBytes((f), (p), 4L)
#define WriteInt16(f, p)   WriteBytes((f), (p), 2L)
#define WriteInt32(f, p)   WriteBytes((f), (p), 4L)
#define WriteFloat32(f, p) WriteBytes((f), (p), 4L)
#endif /* FAT_ENDIAN */

#endif /* _Q_FILES_H_ */
/* end of file */
