/*
 * Copyright (C) 1996 by Raphael Quinet.  All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation.  If more than a few
 * lines of this code are used in a program which displays a copyright
 * notice or credit notice, the following acknowledgment must also be
 * displayed on the same screen: "This product includes software
 * developed by Raphael Quinet for use in the Quake Editing Utilities
 * project."  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR
 * IMPLIED WARRANTY.
 *
 * More information about the QEU project can be found on the WWW:
 * "http://www.montefiore.ulg.ac.be/~quinet/games/editing.html" or by
 * mail: Raphael Quinet, 9 rue des Martyrs, B-4550 Nandrin, Belgium.
 */

#ifndef _F_WAD2_H_
#define _F_WAD2_H_
/*
 * F_WAD2.C - Read and write Quake WAD2 files.
 */

/*
 * The WAD2Directory structure is the structure used by QUAKE to order the
 * data in its WAD2 files.
 *
 * Thanks to Olivier Montanuy for the information about the meaning of
 * "dsize" and "compression", which I found in his "Unofficial Quake Specs".
 */
typedef struct WAD2Directory *WAD2DirPtr;
struct WAD2Directory
{
   UInt32 offset;               /* offset to start of data */
   UInt32 size;                 /* byte size of data in WAD2 file */
   UInt32 dsize;                /* byte size of data when decompressed */
   UInt8  dtype;                /* type of data:
				   @ = raw data
				   B = bitmap with header
				   E = raw bitmap (no header)
				   */
   UInt8  compression;          /* type of compression:
				   0 = no compression
				   */
   UInt16 padding;              /* not used (always 0) */
   char   name[16];             /* name of data block */
};

/* prototypes */
WAD2DirPtr ReadWAD2Directory(FILE *wadfile, UInt32 offset, UInt16 *dirsize_r);
UInt16     FindWAD2Entry(WAD2DirPtr dir, UInt16 dirsize, char *entryname);
void       DumpWAD2Directory(FILE *outf, WAD2DirPtr dir, UInt16 dirsize);
Bool       UnWAD2File(FILE *outf, FILE *wadfile, UInt32 offset, WAD2DirPtr dir,
		      UInt16 dirsize, UInt16 entrynum, char *prefixpath,
		      Bool convert);

Bool       WriteWAD2Header(FILE *wadfile, UInt32 *count_r, WAD2DirPtr *dir_r,
			   UInt16 *dirsize_r);
Bool       AddWAD2Entry(FILE *wadfile, UInt32 *count_r, WAD2DirPtr *dir_r,
			UInt16 *dirsize_r, char *entryname, UInt32 entrysize,
			UInt8 entrytype);
UInt32     WriteWAD2Directory(FILE *wadfile, UInt32 *count_r, WAD2DirPtr dir,
			      UInt16 dirsize);
#endif /* _F_WAD2_H_ */
/* end of file */
