/*
 * Copyright (C) 1996 by Raphael Quinet.  All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation.  If more than a few
 * lines of this code are used in a program which displays a copyright
 * notice or credit notice, the following acknowledgment must also be
 * displayed on the same screen: "This product includes software
 * developed by Raphael Quinet for use in the Quake Editing Utilities
 * project."  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR
 * IMPLIED WARRANTY.
 *
 * More information about the QEU project can be found on the WWW:
 * "http://www.montefiore.ulg.ac.be/~quinet/games/editing.html" or by
 * mail: Raphael Quinet, 9 rue des Martyrs, B-4550 Nandrin, Belgium.
 */

#ifndef _F_WAD_H_
#define _F_WAD_H_
/*
 * F_WAD.H - Read and write Doom/Heretic/Hexen WAD files.
 */

/*
 * The WADDirectory structure is the structure used by DOOM and the
 * games based on the DOOM engine to order the data in its WAD files.
 */
typedef struct WADDirectory *WADDirPtr;
struct WADDirectory
{
   UInt32 offset;               /* offset to start of data */
   UInt32 size;                 /* byte size of data */
   char   name[8];              /* name of data block */
};

/* prototypes */
WADDirPtr ReadWADDirectory(FILE *wadfile, UInt32 offset, UInt16 *dirsize_r);
UInt16    FindWADEntry(WADDirPtr dir, UInt16 dirsize, char *entryname);
void      DumpWADDirectory(FILE *outf, WADDirPtr dir, UInt16 dirsize);
Bool      UnWADFile(FILE *outf, FILE *wadfile, UInt32 offset, WADDirPtr dir,
		    UInt16 dirsize, UInt16 entrynum, char *prefixpath);

Bool      WriteWADHeader(FILE *wadfile, UInt32 *count_r, WADDirPtr *dir_r,
			 UInt16 *dirsize_r, Bool patch);
Bool      AddWADEntry(FILE *wadfile, UInt32 *count_r, WADDirPtr *dir_r,
		      UInt16 *dirsize_r, char *entryname, UInt32 entrysize);
UInt32    WriteWADDirectory(FILE *wadfile, UInt32 *count_r, WADDirPtr dir,
			 UInt16 dirsize);
#endif /* _F_WAD_H_ */
/* end of file */
