/*
 * Copyright (C) 1996 by Chris Johnson.  All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation.  If more than a few
 * lines of this code are used in a program which displays a copyright
 * notice or credit notice, the following acknowledgment must also be
 * displayed on the same screen: "This product includes software
 * developed by Chris Johnson for use in the QuakeDef Tools package."
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESSED OR IMPLIED
 * WARRANTY.
 *
 * (Thanks to Raphael Quinet for this nifty disclaimer!)
 */

#ifndef _QDFUNCT_H_
#define _QDFUNCT_H_

// BSP Header number of elements
#define	BH_NELEM			29
// BSP Header QuakeDef offset element number
#define BH_QD_ELEM			1
// BSP Header QuakeDef (lump) size element number
#define	BH_QDSIZE_ELEM		2
// BSP Header post-QuakeDef offset element number
#define BH_POSTQD_ELEM		5

long *	grab_addresses(FILE *bsp);
int 	export_quake_def(FILE *bsp, FILE *qdf, unsigned long len);
void 	import_quake_def(FILE *qdf, FILE *bsp);
void 	fix_bsp_hdr(FILE *bsp, long *ara, long diff);

#endif