// PAKRAT v1.0  September 15,1998 7:30 a.m.
//
// Source code copyright(C)1998 Mike Nichols, vortech@tiac.net
//
// If you use this code, think about giving me credit. Thanks.
//
// e-mail vortech@tiac.net prior to distribution on commercial CD-ROM,
// or for any other remarks (bugs? NOOOOO! :)
//
// #include <std_disclaimer.h>
//
// Use at your own risk. No guarantees whatsoever. NADA.
//
//
// Compiles under MSVC 5.0. You may have to change some items,
// (_MAX_PATH comes to mind) under different compilers or OSes.
//
// Uh.. forget real-mode DOS compilers. It ain't gonna work.
//

#define DEBUG  //uncomment this if you don't like the prompting


#include <conio.h>
#include <direct.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <io.h>

#define PAKRAT_BANNER "PAKRAT version 1.0"
#define Max_PAK_Entries 25000 // self-evident :)

int c, count = 0;

long Largest_PAK_Entry_Size = 0L;
long PAK_Size;
long PAK_Entries;

char Largest_PAK_Entry_Name[_MAX_PATH];
char *FileBuffer;
char Pack_Name[_MAX_PATH];
char temp[_MAX_PATH];

FILE *PAK_FILE;
FILE *Out_FILE;
FILE *Log_FILE;

typedef struct
{
	long PAK_ID;
	long PAK_DirStart;
	long PAK_DirSize;
} PAK_Header_Type;

PAK_Header_Type PAK_Header;


typedef struct
{
	char FileName[56];
	long Offset;
	long Size;
} PAK_Entry_Type;

PAK_Entry_Type PAK_Entry[Max_PAK_Entries]; 

void HitAKey(void)
{
	cprintf("\n[Hit a Key]\n");
	getch();
}


int main(int argc, char *argv[]) 
{
	cprintf("\n%s\n\n",PAKRAT_BANNER);

	if(argc < 2)
	{
		cprintf("No file specified. Exiting.\n");

#ifdef DEBUG
		HitAKey();
#endif
		return(0);
	}

	strcpy(Pack_Name,argv[1]);

	if((PAK_FILE = fopen(Pack_Name,"rb")) == NULL)
	{
		cprintf("Error opening file %s\n",argv[1]);

#ifdef DEBUG
		HitAKey();
#endif
		return(-1);
	}
	
	PAK_Size = filelength(fileno(PAK_FILE));
	
	fread(&PAK_Header,sizeof(PAK_Header),1,PAK_FILE);

	if(PAK_Header.PAK_ID != 0x4b434150) //'PACK'
	{
		fcloseall();

		cprintf("Error! %s is not an 'id .PAK' file!\n\b",Pack_Name);

#ifdef DEBUG
		HitAKey();
#endif
		return(-1);
	}

	PAK_Entries = PAK_Header.PAK_DirSize >> 6;
	//64 bytes/entry : 2 << 5 = 64
	
	cprintf("PAK info :\nName     : %s\nID       : 0x%x (PACK)\nSize \
		     : %ld\nDir Start: %ld\nDir Size : %ld\nEntries  : %ld\n",
		     Pack_Name,
			 PAK_Header.PAK_ID,
			 PAK_Size,
			 PAK_Header.PAK_DirStart,
			 PAK_Header.PAK_DirSize,
			 PAK_Entries);

	fseek(PAK_FILE,PAK_Header.PAK_DirStart,SEEK_SET);
	fread(&PAK_Entry,sizeof(char),PAK_Header.PAK_DirSize,PAK_FILE);

	for(count=0;count < PAK_Entries; count++)
	{
		if(PAK_Entry[count].Size > Largest_PAK_Entry_Size)
		{
			Largest_PAK_Entry_Size = PAK_Entry[count].Size;
			strcpy(Largest_PAK_Entry_Name,PAK_Entry[count].FileName);
		}
	}
	
	cprintf("Largest file: %s  Size: %ld\n",
		     Largest_PAK_Entry_Name,
			 Largest_PAK_Entry_Size);

#ifdef DEBUG
	HitAKey();
#endif

	FileBuffer = (char *)malloc(Largest_PAK_Entry_Size);
	
	if(!FileBuffer)
	{
	 fcloseall();
	 cprintf("Error allocating memory for file-copy buffer!\n  \
		     (Need at least %ld bytes free)\n\n",
			  Largest_PAK_Entry_Size);

#ifdef DEBUG
	 HitAKey();
#endif
	 return(-1);
	}

	
	Log_FILE = fopen("PAKRAT.LOG","wt+");

    fseek(PAK_FILE,PAK_Entry[0].Offset,SEEK_SET);

    for(count=0;count < PAK_Entries; count++)
	{
		cprintf("%ld: Name: %s Size: %ld\n",
			     count+1,
				 PAK_Entry[count].FileName,
				 PAK_Entry[count].Size);
		fprintf(Log_FILE,"%ld: Name: %s Size: %ld\n",
			     count+1,
				 PAK_Entry[count].FileName,
				 PAK_Entry[count].Size);

		Out_FILE = fopen(PAK_Entry[count].FileName,"wb");

		if(Out_FILE == NULL)
		{
			//example: models/items/quaddama/skin.pcx
			strcpy(temp,PAK_Entry[count].FileName);
			c = 0;
			while(temp[c])
			{
				if((temp[c] == '/') || (temp[c] == '\\'))
				{
					temp[c] = '\0';
					mkdir(temp);
					temp[c] = '/';
				}
				c++;
			}

			Out_FILE = fopen(PAK_Entry[count].FileName,"wb");

			if(Out_FILE == NULL)
			{
				cprintf("Error creating file: %s\n",temp);
				fcloseall();
				free(FileBuffer);
#ifdef DEBUG
				HitAKey();
#endif
				return(-1);
			}
		}

		fread(FileBuffer,PAK_Entry[count].Size,1,PAK_FILE);
		fwrite(FileBuffer,PAK_Entry[count].Size,1,Out_FILE);
		fclose(Out_FILE);
	}

	fcloseall();	
	
	free(FileBuffer);
	
	return(0);
}

