diff -ur --new-file v101/eject.qc ejects~1/eject.qc
--- v101/eject.qc	Wed Dec 31 19:00:00 1969
+++ ejects~1/eject.qc	Sun Sep  8 14:06:02 1996
@@ -0,0 +1,89 @@
+// To find changes search for "rd mod" without quotes
+/*========================================================================
+
+Eject.qc - 8/14/96 Steve Bond (wedge)
+
+========================================================================*/
+
+//rd mod start
+float() crandom;
+//rd mod end
+void() shell_touch;
+
+/*
+===============
+eject_shell
+
+Spews a spent shell casing from a shotgun
+===============
+*/
+//rd mod start
+void(vector org,vector dir, float punch, vector spread) eject_shell =
+//rd mod end
+{
+        local float     flip; 
+//rd mod start
+	local vector transform;
+//rd mod end
+        // Spawn one shell
+	newmis = spawn ();
+	newmis.owner = self;
+        newmis.movetype = MOVETYPE_BOUNCE;
+	newmis.solid = SOLID_BBOX;
+
+	newmis.angles = vectoangles(dir);
+	
+        newmis.touch = shell_touch;
+        newmis.classname = "shellcasing";
+	newmis.think = SUB_Remove;
+//rd mod start
+        newmis.nextthink = time + 10;
+//rd mod end
+        setmodel (newmis, "shelcase.mdl");
+	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);               
+	setorigin (newmis, org);
+        // pick a random numbers
+//rd mod start
+	flip = crandom();
+	spread_x = spread_x * flip; 
+	flip = crandom();
+	spread_y = spread_y * flip; 
+	flip = crandom();
+	spread_z = spread_z * flip; 
+
+      transform_x = dir_y + spread_x;
+	transform_y = 0 - dir_x + spread_y;
+	transform_z = dir_z + spread_z;  
+        newmis.velocity = transform*punch;
+//rd mod end
+
+        // pick a random number
+        flip = random();
+
+        // based on that rate, pick a rate at which to spin
+        if (flip < 0.25)
+        newmis.avelocity = '300 300 300';
+
+        else if (flip < 0.5)
+        newmis.avelocity = '150 300 100';
+
+        else if (flip < 0.75)
+        newmis.avelocity = '200 100 0';
+
+        else
+        newmis.avelocity = '400 200 100';
+};
+
+
+
+
+void() shell_touch =
+{
+     // DO NOT play the sound if we hit a door.
+     if (other.classname == "door")
+        return;
+
+     sound (self, CHAN_WEAPON, "shellhit.wav", 1, ATTN_NORM);
+};
+
+
diff -ur --new-file v101/progs.src ejects~1/progs.src
--- v101/progs.src	Thu Jul 25 01:51:28 1996
+++ ejects~1/progs.src	Wed Aug 14 22:43:26 1996
@@ -6,7 +6,11 @@
 ai.qc
 combat.qc
 items.qc
+
+eject.qc
+
 weapons.qc
+
 world.qc
 client.qc
 player.qc
@@ -27,9 +31,10 @@
 zombie.qc
 boss.qc
 
-tarbaby.qc		// registered
-hknight.qc		// registered
-fish.qc			// registered
-shalrath.qc		// registered
-enforcer.qc		// registered
-oldone.qc		// registered
+tarbaby.qc              // registered
+hknight.qc              // registered
+fish.qc                 // registered
+shalrath.qc             // registered
+enforcer.qc             // registered
+oldone.qc               // registered
+
diff -ur --new-file v101/soldier.qc ejects~1/soldier.qc
--- v101/soldier.qc	Thu Jul 25 01:51:24 1996
+++ ejects~1/soldier.qc	Sun Sep  8 14:02:54 1996
@@ -1,3 +1,4 @@
+// To find changes search for "rd mod" without quotes
 /*
 ==============================================================================
 
@@ -171,6 +172,9 @@
 	}
 };
 
+//rd mod start
+void(vector org,vector dir, float punch, vector spread) eject_shell;
+//rd mod end
 
 void() army_fire =
 {
@@ -188,6 +192,9 @@
 	dir = normalize (dir - self.origin);
 	
 	FireBullets (4, dir, '0.1 0.1 0');
+//rd mod start
+      eject_shell (self.origin + '0 0 16' + v_forward*3,dir, 200, '.5 .5 .5');
+//rd mod end
 };
 
 
diff -ur --new-file v101/weapons.qc ejects~1/weapons.qc
--- v101/weapons.qc	Thu Jul 25 01:51:24 1996
+++ ejects~1/weapons.qc	Sun Sep  8 14:02:30 1996
@@ -1,3 +1,4 @@
+// To find changes search for "rd mod" without quotes
 /*
 */
 void (entity targ, entity inflictor, entity attacker, float damage) T_Damage;
@@ -6,22 +7,28 @@
 void(vector org, vector vel, float damage) SpawnBlood;
 void() SuperDamageSound;
 
+//rd mod start
+void(vector org,vector dir, float punch, vector spread) eject_shell;
+//rd mod end
 
 // called by worldspawn
 void() W_Precache =
 {
-	precache_sound ("weapons/r_exp3.wav");	// new rocket explosion
-	precache_sound ("weapons/rocket1i.wav");	// spike gun
+        precache_model ("shelcase.mdl");  // Shell Casing
+        precache_sound ("shellhit.wav");  // Shell Casing
+
+	precache_sound ("weapons/r_exp3.wav");  // new rocket explosion
+	precache_sound ("weapons/rocket1i.wav");        // spike gun
 	precache_sound ("weapons/sgun1.wav");
-	precache_sound ("weapons/guncock.wav");	// player shotgun
-	precache_sound ("weapons/ric1.wav");	// ricochet (used in c code)
-	precache_sound ("weapons/ric2.wav");	// ricochet (used in c code)
-	precache_sound ("weapons/ric3.wav");	// ricochet (used in c code)
-	precache_sound ("weapons/spike2.wav");	// super spikes
-	precache_sound ("weapons/tink1.wav");	// spikes tink (used in c code)
-	precache_sound ("weapons/grenade.wav");	// grenade launcher
-	precache_sound ("weapons/bounce.wav");		// grenade bounce
-	precache_sound ("weapons/shotgn2.wav");	// super shotgun
+	precache_sound ("weapons/guncock.wav"); // player shotgun
+	precache_sound ("weapons/ric1.wav");    // ricochet (used in c code)
+	precache_sound ("weapons/ric2.wav");    // ricochet (used in c code)
+	precache_sound ("weapons/ric3.wav");    // ricochet (used in c code)
+	precache_sound ("weapons/spike2.wav");  // super spikes
+	precache_sound ("weapons/tink1.wav");   // spikes tink (used in c code)
+	precache_sound ("weapons/grenade.wav"); // grenade launcher
+	precache_sound ("weapons/bounce.wav");          // grenade bounce
+	precache_sound ("weapons/shotgn2.wav"); // super shotgun
 };
 
 float() crandom =
@@ -36,8 +43,8 @@
 */
 void() W_FireAxe =
 {
-	local	vector	source;
-	local	vector	org;
+	local   vector  source;
+	local   vector  org;
 
 	source = self.origin + '0 0 16';
 	traceline (source, source + v_forward*64, FALSE, self);
@@ -53,7 +60,7 @@
 		T_Damage (trace_ent, self, self, 20);
 	}
 	else
-	{	// hit wall
+	{       // hit wall
 		sound (self, CHAN_WEAPON, "player/axhit2.wav", 1, ATTN_NORM);
 		WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
 		WriteByte (MSG_BROADCAST, TE_GUNSHOT);
@@ -69,7 +76,7 @@
 
 vector() wall_velocity =
 {
-	local vector	vel;
+	local vector    vel;
 	
 	vel = normalize (self.velocity);
 	vel = normalize(vel + v_up*(random()- 0.5) + v_right*(random()- 0.5));
@@ -87,8 +94,8 @@
 */
 void(vector org, vector vel) SpawnMeatSpray =
 {
-	local	entity missile, mpuff;
-	local	vector	org;
+	local   entity missile, mpuff;
+	local   vector  org;
 
 	missile = spawn ();
 	missile.owner = self;
@@ -107,7 +114,7 @@
 	missile.think = SUB_Remove;
 
 	setmodel (missile, "progs/zom_gib.mdl");
-	setsize (missile, '0 0 0', '0 0 0');		
+	setsize (missile, '0 0 0', '0 0 0');            
 	setorigin (missile, org);
 };
 
@@ -128,7 +135,7 @@
 */
 void(float damage) spawn_touchblood =
 {
-	local vector	vel;
+	local vector    vel;
 
 	vel = wall_velocity () * 0.2;
 	SpawnBlood (self.origin + vel*0.01, vel, damage);
@@ -155,8 +162,8 @@
 ==============================================================================
 */
 
-entity	multi_ent;
-float	multi_damage;
+entity  multi_ent;
+float   multi_damage;
 
 void() ClearMultiDamage =
 {
@@ -201,7 +208,7 @@
 */
 void(float damage, vector dir) TraceAttack =
 {
-	local	vector	vel, org;
+	local   vector  vel, org;
 	
 	vel = normalize(dir + v_up*crandom() + v_right*crandom());
 	vel = vel + 2*trace_plane_normal;
@@ -234,8 +241,8 @@
 */
 void(float shotcount, vector dir, vector spread) FireBullets =
 {
-	local	vector direction;
-	local	vector	src;
+	local   vector direction;
+	local   vector  src;
 	
 	makevectors(self.v_angle);
 
@@ -265,12 +272,17 @@
 {
 	local vector dir;
 
-	sound (self, CHAN_WEAPON, "weapons/guncock.wav", 1, ATTN_NORM);	
+	sound (self, CHAN_WEAPON, "weapons/guncock.wav", 1, ATTN_NORM); 
 
 	self.punchangle_x = -2;
 	
 	self.currentammo = self.ammo_shells = self.ammo_shells - 1;
 	dir = aim (self, 100000);
+
+//rd mod start
+        eject_shell (self.origin + '0 0 16' + v_forward*3,dir, 200, '.5 .5 .5');
+//rd mod end
+
 	FireBullets (6, dir, '0.04 0.04 0');
 };
 
@@ -290,12 +302,18 @@
 		return;
 	}
 		
-	sound (self ,CHAN_WEAPON, "weapons/shotgn2.wav", 1, ATTN_NORM);	
+	sound (self ,CHAN_WEAPON, "weapons/shotgn2.wav", 1, ATTN_NORM); 
 
 	self.punchangle_x = -4;
 	
 	self.currentammo = self.ammo_shells = self.ammo_shells - 2;
 	dir = aim (self, 100000);
+
+//rd mod start
+        eject_shell (self.origin + '0 0 16' + v_forward*3,dir, 400, '0.3 0.3 0.3');
+        eject_shell (self.origin + '0 0 16' + v_forward*3,dir, 400, '0.3 0.3 0.3');
+//rd mod end
+
 	FireBullets (14, dir, '0.14 0.08 0');
 };
 
@@ -308,12 +326,12 @@
 ==============================================================================
 */
 
-void()	s_explode1	=	[0,		s_explode2] {};
-void()	s_explode2	=	[1,		s_explode3] {};
-void()	s_explode3	=	[2,		s_explode4] {};
-void()	s_explode4	=	[3,		s_explode5] {};
-void()	s_explode5	=	[4,		s_explode6] {};
-void()	s_explode6	=	[5,		SUB_Remove] {};
+void()  s_explode1      =       [0,             s_explode2] {};
+void()  s_explode2      =       [1,             s_explode3] {};
+void()  s_explode3      =       [2,             s_explode4] {};
+void()  s_explode4      =       [3,             s_explode5] {};
+void()  s_explode5      =       [4,             s_explode6] {};
+void()  s_explode6      =       [5,             SUB_Remove] {};
 
 void() BecomeExplosion =
 {
@@ -327,10 +345,10 @@
 
 void() T_MissileTouch =
 {
-	local float	damg;
+	local float     damg;
 
 	if (other == self.owner)
-		return;		// don't explode on owner
+		return;         // don't explode on owner
 
 	if (pointcontents(self.origin) == CONTENT_SKY)
 	{
@@ -343,7 +361,7 @@
 	if (other.health)
 	{
 		if (other.classname == "monster_shambler")
-			damg = damg * 0.5;	// mostly immune
+			damg = damg * 0.5;      // mostly immune
 		T_Damage (other, self, self.owner, damg );
 	}
 
@@ -351,7 +369,7 @@
 	// was done in the impact
 	T_RadiusDamage (self, self.owner, 120, other);
 
-//	sound (self, CHAN_WEAPON, "weapons/r_exp3.wav", 1, ATTN_NORM);
+//      sound (self, CHAN_WEAPON, "weapons/r_exp3.wav", 1, ATTN_NORM);
 	self.origin = self.origin - 8*normalize(self.velocity);
 
 	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
@@ -372,7 +390,7 @@
 */
 void() W_FireRocket =
 {
-	local	entity missile, mpuff;
+	local   entity missile, mpuff;
 	
 	self.currentammo = self.ammo_rockets = self.ammo_rockets - 1;
 	
@@ -385,7 +403,7 @@
 	missile.movetype = MOVETYPE_FLYMISSILE;
 	missile.solid = SOLID_BBOX;
 		
-// set missile speed	
+// set missile speed    
 
 	makevectors (self.v_angle);
 	missile.velocity = aim(self, 1000);
@@ -399,7 +417,7 @@
 	missile.think = SUB_Remove;
 
 	setmodel (missile, "progs/missile.mdl");
-	setsize (missile, '0 0 0', '0 0 0');		
+	setsize (missile, '0 0 0', '0 0 0');            
 	setorigin (missile, self.origin + v_forward*8 + '0 0 16');
 };
 
@@ -418,8 +436,8 @@
 */
 void(vector p1, vector p2, entity from, float damage) LightningDamage =
 {
-	local entity		e1, e2;
-	local vector		f;
+	local entity            e1, e2;
+	local vector            f;
 	
 	f = p2 - p1;
 	normalize (f);
@@ -462,7 +480,7 @@
 
 void() W_FireLightning =
 {
-	local	vector		org;
+	local   vector          org;
 
 	if (self.ammo_cells < 1)
 	{
@@ -526,13 +544,13 @@
 void() GrenadeTouch =
 {
 	if (other == self.owner)
-		return;		// don't explode on owner
+		return;         // don't explode on owner
 	if (other.takedamage == DAMAGE_AIM)
 	{
 		GrenadeExplode();
 		return;
 	}
-	sound (self, CHAN_WEAPON, "weapons/bounce.wav", 1, ATTN_NORM);	// bounce sound
+	sound (self, CHAN_WEAPON, "weapons/bounce.wav", 1, ATTN_NORM);  // bounce sound
 	if (self.velocity == '0 0 0')
 		self.avelocity = '0 0 0';
 };
@@ -544,7 +562,7 @@
 */
 void() W_FireGrenade =
 {
-	local	entity missile, mpuff;
+	local   entity missile, mpuff;
 	
 	self.currentammo = self.ammo_rockets = self.ammo_rockets - 1;
 	
@@ -558,7 +576,7 @@
 	missile.solid = SOLID_BBOX;
 	missile.classname = "grenade";
 		
-// set missile speed	
+// set missile speed    
 
 	makevectors (self.v_angle);
 
@@ -582,7 +600,7 @@
 	missile.think = GrenadeExplode;
 
 	setmodel (missile, "progs/grenade.mdl");
-	setsize (missile, '0 0 0', '0 0 0');		
+	setsize (missile, '0 0 0', '0 0 0');            
 	setorigin (missile, self.origin);
 };
 
@@ -614,7 +632,7 @@
 	newmis.think = SUB_Remove;
 	newmis.nextthink = time + 6;
 	setmodel (newmis, "progs/spike.mdl");
-	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);		
+	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);               
 	setorigin (newmis, org);
 
 	newmis.velocity = dir * 1000;
@@ -622,8 +640,8 @@
 
 void() W_FireSuperSpikes =
 {
-	local vector	dir;
-	local entity	old;
+	local vector    dir;
+	local entity    old;
 	
 	sound (self, CHAN_WEAPON, "weapons/spike2.wav", 1, ATTN_NORM);
 	self.attack_finished = time + 0.2;
@@ -632,14 +650,14 @@
 	launch_spike (self.origin + '0 0 16', dir);
 	newmis.touch = superspike_touch;
 	setmodel (newmis, "progs/s_spike.mdl");
-	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);		
+	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);               
 	self.punchangle_x = -2;
 };
 
 void(float ox) W_FireSpikes =
 {
-	local vector	dir;
-	local entity	old;
+	local vector    dir;
+	local entity    old;
 	
 	makevectors (self.v_angle);
 	
@@ -675,7 +693,7 @@
 		return;
 
 	if (other.solid == SOLID_TRIGGER)
-		return;	// trigger field, do nothing
+		return; // trigger field, do nothing
 
 	if (pointcontents(self.origin) == CONTENT_SKY)
 	{
@@ -715,7 +733,7 @@
 		return;
 
 	if (other.solid == SOLID_TRIGGER)
-		return;	// trigger field, do nothing
+		return; // trigger field, do nothing
 
 	if (pointcontents(self.origin) == CONTENT_SKY)
 	{
@@ -753,7 +771,7 @@
 
 void() W_SetCurrentAmmo =
 {
-	player_run ();		// get out of any weapon firing states
+	player_run ();          // get out of any weapon firing states
 
 	self.items = self.items - ( self.items & (IT_SHELLS | IT_NAILS | IT_ROCKETS | IT_CELLS) );
 	
@@ -822,7 +840,7 @@
 
 float() W_BestWeapon =
 {
-	local	float	it;
+	local   float   it;
 	
 	it = self.items;
 
@@ -871,24 +889,24 @@
 An attack impulse can be triggered now
 ============
 */
-void()	player_axe1;
-void()	player_axeb1;
-void()	player_axec1;
-void()	player_axed1;
-void()	player_shot1;
-void()	player_nail1;
-void()	player_light1;
-void()	player_rocket1;
+void()  player_axe1;
+void()  player_axeb1;
+void()  player_axec1;
+void()  player_axed1;
+void()  player_shot1;
+void()  player_nail1;
+void()  player_light1;
+void()  player_rocket1;
 
 void() W_Attack =
 {
-	local	float	r;
+	local   float   r;
 
 	if (!W_CheckNoAmmo ())
 		return;
 
-	makevectors	(self.v_angle);			// calculate forward angle for velocity
-	self.show_hostile = time + 1;	// wake monsters up
+	makevectors     (self.v_angle);                 // calculate forward angle for velocity
+	self.show_hostile = time + 1;   // wake monsters up
 
 	if (self.weapon == IT_AXE)
 	{
@@ -952,7 +970,7 @@
 */
 void() W_ChangeWeapon =
 {
-	local	float	it, am, fl;
+	local   float   it, am, fl;
 	
 	it = self.items;
 	am = 0;
@@ -972,7 +990,7 @@
 		fl = IT_SUPER_SHOTGUN;
 		if (self.ammo_shells < 2)
 			am = 1;
-	}		
+	}               
 	else if (self.impulse == 4)
 	{
 		fl = IT_NAILGUN;
@@ -1007,13 +1025,13 @@
 	self.impulse = 0;
 	
 	if (!(self.items & fl))
-	{	// don't have the weapon or the ammo
+	{       // don't have the weapon or the ammo
 		sprint (self, "no weapon.\n");
 		return;
 	}
 	
 	if (am)
-	{	// don't have the ammo
+	{       // don't have the ammo
 		sprint (self, "not enough ammo.\n");
 		return;
 	}
@@ -1021,7 +1039,7 @@
 //
 // set weapon, set ammo
 //
-	self.weapon = fl;		
+	self.weapon = fl;               
 	W_SetCurrentAmmo ();
 };
 
@@ -1065,7 +1083,7 @@
 */
 void() CycleWeaponCommand =
 {
-	local	float	it, am;
+	local   float   it, am;
 	
 	it = self.items;
 	self.impulse = 0;
@@ -1089,7 +1107,7 @@
 			self.weapon = IT_SUPER_SHOTGUN;
 			if (self.ammo_shells < 2)
 				am = 1;
-		}		
+		}               
 		else if (self.weapon == IT_SUPER_SHOTGUN)
 		{
 			self.weapon = IT_NAILGUN;
