diff -ur --new-file ..\qcsrc/defs.qc .\src/defs.qc
--- ..\qcsrc/defs.qc	Thu Sep 26 11:15:38 1996
+++ .\src/defs.qc	Fri Jul 11 21:10:24 1997
@@ -689,5 +689,3 @@
 float (entity e, float healamount, float ignore) T_Heal; // health function
 
 float(entity targ, entity inflictor) CanDamage;
-
-
diff -ur --new-file ..\qcsrc/items.qc .\src/items.qc
--- ..\qcsrc/items.qc	Thu Sep 26 11:15:38 1996
+++ .\src/items.qc	Fri Jul 11 15:02:46 1997
@@ -353,13 +353,14 @@
 		return 2;
 	if (w == IT_SUPER_NAILGUN)
 		return 3;
-	if (w == IT_GRENADE_LAUNCHER)
+        if (w == IT_GRENADE_LAUNCHER || w == IT_EXTRA_WEAPON)
 		return 4;
 	if (w == IT_SUPER_SHOTGUN)
 		return 5;
 	if (w == IT_NAILGUN)
 		return 6;
-	return 7;
+        return 7;
+
 };
 
 /*
@@ -443,12 +444,12 @@
 	}
 	else if (self.classname == "weapon_grenadelauncher")
 	{
-		if (leave && (other.items & IT_GRENADE_LAUNCHER) )
+                if (leave && (other.items & IT_GRENADE_LAUNCHER) )
 			return;
 		hadammo = other.ammo_rockets;			
 		new = IT_GRENADE_LAUNCHER;
-		other.ammo_rockets = other.ammo_rockets + 5;
-	}
+                other.ammo_rockets = other.ammo_rockets + 5;
+        }
 	else if (self.classname == "weapon_lightning")
 	{
 		if (leave && (other.items & IT_LIGHTNING) )
@@ -1352,6 +1353,8 @@
 		item.netname = "Super Nailgun";
 	else if (item.items == IT_GRENADE_LAUNCHER)
 		item.netname = "Grenade Launcher";
+        else if (item.items == IT_EXTRA_WEAPON)
+                item.netname = "Gib Gun";
 	else if (item.items == IT_ROCKET_LAUNCHER)
 		item.netname = "Rocket Launcher";
 	else if (item.items == IT_LIGHTNING)
diff -ur --new-file ..\qcsrc/player.qc .\src/player.qc
--- ..\qcsrc/player.qc	Thu Sep 26 11:15:40 1996
+++ .\src/player.qc	Fri Jul 11 13:19:20 1997
@@ -432,50 +432,6 @@
 	self.deadflag = DEAD_DEAD;
 };
 
-vector(float dm) VelocityForDamage =
-{
-	local vector v;
-
-	v_x = 100 * crandom();
-	v_y = 100 * crandom();
-	v_z = 200 + 100 * random();
-
-	if (dm > -50)
-	{
-//		dprint ("level 1\n");
-		v = v * 0.7;
-	}
-	else if (dm > -200)
-	{
-//		dprint ("level 3\n");
-		v = v * 2;
-	}
-	else
-		v = v * 10;
-
-	return v;
-};
-
-void(string gibname, float dm) ThrowGib =
-{
-	local	entity new;
-
-	new = spawn();
-	new.origin = self.origin;
-	setmodel (new, gibname);
-	setsize (new, '0 0 0', '0 0 0');
-	new.velocity = VelocityForDamage (dm);
-	new.movetype = MOVETYPE_BOUNCE;
-	new.solid = SOLID_NOT;
-	new.avelocity_x = random()*600;
-	new.avelocity_y = random()*600;
-	new.avelocity_z = random()*600;
-	new.think = SUB_Remove;
-	new.ltime = time;
-	new.nextthink = time + 10 + random()*10;
-	new.frame = 0;
-	new.flags = 0;
-};
 
 void(string gibname, float dm) ThrowHead =
 {
diff -ur --new-file ..\qcsrc/progdefs.h .\src/progdefs.h
--- ..\qcsrc/progdefs.h	Thu Jan  1 00:00:00 1970
+++ .\src/progdefs.h	Fri Jul 11 21:47:04 1997
@@ -0,0 +1,143 @@
+
+/* file generated by qcc, do not modify */
+
+typedef struct
+{	int	pad[28];
+	int	self;
+	int	other;
+	int	world;
+	float	time;
+	float	frametime;
+	float	force_retouch;
+	string_t	mapname;
+	float	deathmatch;
+	float	coop;
+	float	teamplay;
+	float	serverflags;
+	float	total_secrets;
+	float	total_monsters;
+	float	found_secrets;
+	float	killed_monsters;
+	float	parm1;
+	float	parm2;
+	float	parm3;
+	float	parm4;
+	float	parm5;
+	float	parm6;
+	float	parm7;
+	float	parm8;
+	float	parm9;
+	float	parm10;
+	float	parm11;
+	float	parm12;
+	float	parm13;
+	float	parm14;
+	float	parm15;
+	float	parm16;
+	vec3_t	v_forward;
+	vec3_t	v_up;
+	vec3_t	v_right;
+	float	trace_allsolid;
+	float	trace_startsolid;
+	float	trace_fraction;
+	vec3_t	trace_endpos;
+	vec3_t	trace_plane_normal;
+	float	trace_plane_dist;
+	int	trace_ent;
+	float	trace_inopen;
+	float	trace_inwater;
+	int	msg_entity;
+	func_t	main;
+	func_t	StartFrame;
+	func_t	PlayerPreThink;
+	func_t	PlayerPostThink;
+	func_t	ClientKill;
+	func_t	ClientConnect;
+	func_t	PutClientInServer;
+	func_t	ClientDisconnect;
+	func_t	SetNewParms;
+	func_t	SetChangeParms;
+} globalvars_t;
+
+typedef struct
+{
+	float	modelindex;
+	vec3_t	absmin;
+	vec3_t	absmax;
+	float	ltime;
+	float	movetype;
+	float	solid;
+	vec3_t	origin;
+	vec3_t	oldorigin;
+	vec3_t	velocity;
+	vec3_t	angles;
+	vec3_t	avelocity;
+	vec3_t	punchangle;
+	string_t	classname;
+	string_t	model;
+	float	frame;
+	float	skin;
+	float	effects;
+	vec3_t	mins;
+	vec3_t	maxs;
+	vec3_t	size;
+	func_t	touch;
+	func_t	use;
+	func_t	think;
+	func_t	blocked;
+	float	nextthink;
+	int	groundentity;
+	float	health;
+	float	frags;
+	float	weapon;
+	string_t	weaponmodel;
+	float	weaponframe;
+	float	currentammo;
+	float	ammo_shells;
+	float	ammo_nails;
+	float	ammo_rockets;
+	float	ammo_cells;
+	float	items;
+	float	takedamage;
+	int	chain;
+	float	deadflag;
+	vec3_t	view_ofs;
+	float	button0;
+	float	button1;
+	float	button2;
+	float	impulse;
+	float	fixangle;
+	vec3_t	v_angle;
+	float	idealpitch;
+	string_t	netname;
+	int	enemy;
+	float	flags;
+	float	colormap;
+	float	team;
+	float	max_health;
+	float	teleport_time;
+	float	armortype;
+	float	armorvalue;
+	float	waterlevel;
+	float	watertype;
+	float	ideal_yaw;
+	float	yaw_speed;
+	int	aiment;
+	int	goalentity;
+	float	spawnflags;
+	string_t	target;
+	string_t	targetname;
+	float	dmg_take;
+	float	dmg_save;
+	int	dmg_inflictor;
+	int	owner;
+	vec3_t	movedir;
+	string_t	message;
+	float	sounds;
+	string_t	noise;
+	string_t	noise1;
+	string_t	noise2;
+	string_t	noise3;
+} entvars_t;
+
+#define PROGHEADER_CRC 5927
diff -ur --new-file ..\qcsrc/test.bat .\src/test.bat
--- ..\qcsrc/test.bat	Thu Jan  1 00:00:00 1970
+++ .\src/test.bat	Fri Jul 11 12:26:38 1997
@@ -0,0 +1,4 @@
+@echo off
+..\qccdos
+cd\quake
+quake -game danqc +skill %1 +map %2 %3 %4 %5
\ No newline at end of file
diff -ur --new-file ..\qcsrc/weapons.qc .\src/weapons.qc
--- ..\qcsrc/weapons.qc	Mon Sep 30 03:08:08 1996
+++ .\src/weapons.qc	Fri Jul 11 21:46:10 1997
@@ -22,6 +22,9 @@
 	precache_sound ("weapons/grenade.wav");	// grenade launcher
 	precache_sound ("weapons/bounce.wav");		// grenade bounce
 	precache_sound ("weapons/shotgn2.wav");	// super shotgun
+        precache_sound ("zombie/z_miss.wav"); // gibgun
+	precache_sound ("doors/airdoor1.wav"); // gibgun
+	precache_sound ("doors/airdoor2.wav"); // gibgun
 };
 
 float() crandom =
@@ -276,6 +279,7 @@
 };
 
 
+
 /*
 ================
 W_FireSuperShotgun
@@ -325,6 +329,67 @@
 	self.solid = SOLID_NOT;
 	s_explode1 ();
 };
+/*
+======================================
+Gibshit
+======================================
+*/
+vector(float dm) VelocityForDamage =
+{
+	local vector v;
+
+	v_x = 100 * crandom();
+	v_y = 100 * crandom();
+	v_z = 200 + 100 * random();
+
+	if (dm > -50)
+	{
+//		dprint ("level 1\n");
+		v = v * 0.7;
+	}
+	else if (dm > -200)
+	{
+//		dprint ("level 3\n");
+		v = v * 2;
+	}
+	else
+		v = v * 10;
+
+	return v;
+};
+
+void(string gibname, float dm) ThrowGib =
+{
+	local	entity new;
+
+	new = spawn();
+	new.origin = self.origin;
+	setmodel (new, gibname);
+	setsize (new, '0 0 0', '0 0 0');
+	new.velocity = VelocityForDamage (dm);
+	new.movetype = MOVETYPE_BOUNCE;
+	new.solid = SOLID_NOT;
+	new.avelocity_x = random()*600;
+	new.avelocity_y = random()*600;
+	new.avelocity_z = random()*600;
+	new.think = SUB_Remove;
+	new.ltime = time;
+	new.nextthink = time + 10 + random()*10;
+	new.frame = 0;
+	new.flags = 0;
+};
+
+void() BecomeGiblosion =
+{
+	self.movetype = MOVETYPE_NONE;
+	self.velocity = '0 0 0';
+	self.touch = SUB_Null;
+        ThrowGib ("progs/gib2.mdl", -10);
+        ThrowGib ("progs/gib1.mdl", -10);
+        ThrowGib ("progs/zom_gib.mdl", -10);
+	self.solid = SOLID_NOT;
+        remove(self);        
+};
 
 void() T_MissileTouch =
 {
@@ -514,6 +579,13 @@
 //=============================================================================
 
 
+void() GibExplode =
+{
+        T_RadiusDamage (self, self.owner, 72, world);
+        sound (self, CHAN_WEAPON, "player/udeath.wav", 1, ATTN_NORM);
+        BecomeGiblosion ();
+};
+
 void() GrenadeExplode =
 {
 	T_RadiusDamage (self, self.owner, 120, world);
@@ -541,6 +613,20 @@
 		self.avelocity = '0 0 0';
 };
 
+void() GibgTouch =
+{
+	if (other == self.owner)
+		return;		// don't explode on owner
+	if (other.takedamage == DAMAGE_AIM)
+	{
+                GibExplode();
+		return;
+	}
+        sound (self, CHAN_WEAPON, "zombie/z_miss.wav", 1, ATTN_NORM); // spluck sound
+	if (self.velocity == '0 0 0')
+		self.avelocity = '0 0 0';
+};
+
 /*
 ================
 W_FireGrenade
@@ -590,6 +676,56 @@
 	setorigin (missile, self.origin);
 };
 
+/*
+================
+W_FireGibgun - Dan Warner
+================
+*/
+void() W_FireGibgun =
+{
+	local	entity missile, mpuff;
+	
+                self.currentammo = self.ammo_shells = self.ammo_shells - 3;
+	
+        sound (self, CHAN_WEAPON, "doors/airdoor1.wav", 1, ATTN_NORM);
+        sound (self, CHAN_WEAPON, "doors/airdoor2.wav", 1, ATTN_NORM);
+
+	self.punchangle_x = -2;
+
+	missile = spawn ();
+	missile.owner = self;
+	missile.movetype = MOVETYPE_BOUNCE;
+	missile.solid = SOLID_BBOX;
+        missile.classname = "gibnade";
+		
+// set missile speed	
+
+	makevectors (self.v_angle);
+
+	if (self.v_angle_x)
+		missile.velocity = v_forward*600 + v_up * 200 + crandom()*v_right*10 + crandom()*v_up*10;
+	else
+	{
+		missile.velocity = aim(self, 10000);
+		missile.velocity = missile.velocity * 600;
+		missile.velocity_z = 200;
+	}
+
+	missile.avelocity = '300 300 300';
+
+	missile.angles = vectoangles(missile.velocity);
+	
+        missile.touch = GibgTouch;
+	
+// set missile duration
+	missile.nextthink = time + 2.5;
+        missile.think = GibExplode;
+
+        setmodel (missile, "progs/gib3.mdl");
+	setsize (missile, '0 0 0', '0 0 0');		
+	setorigin (missile, self.origin);
+};
+
 
 //=============================================================================
 
@@ -802,6 +938,13 @@
 		self.weaponframe = 0;
 		self.items = self.items | IT_ROCKETS;
 	}
+        else if (self.weapon == IT_EXTRA_WEAPON)
+        {
+                self.currentammo = self.ammo_shells;
+                self.weaponmodel = "progs/v_rock.mdl";
+                self.weaponframe = 0;
+                self.items = self.items | IT_SHELLS;
+        }
 	else if (self.weapon == IT_ROCKET_LAUNCHER)
 	{
 		self.currentammo = self.ammo_rockets;
@@ -925,6 +1068,12 @@
 		W_FireGrenade();
 		self.attack_finished = time + 0.6;
 	}
+        else if (self.weapon == IT_EXTRA_WEAPON)
+	{
+                player_shot1();
+                W_FireGibgun();
+                self.attack_finished = time + 0.8;
+	}
 	else if (self.weapon == IT_ROCKET_LAUNCHER)
 	{
 		player_rocket1();
@@ -982,9 +1131,17 @@
 	}
 	else if (self.impulse == 6)
 	{
+		if (self.weapon == IT_GRENADE_LAUNCHER)
+		{ 
+                        self.weapon = IT_EXTRA_WEAPON;
+                        sprint(self,"Gib Launcher\n");
+			return;
+		} 
+
 		fl = IT_GRENADE_LAUNCHER;
 		if (self.ammo_rockets < 1)
 			am = 1;
+                if (!am) sprint(self,"Grenade Launcher\n");
 	}
 	else if (self.impulse == 7)
 	{
@@ -997,9 +1154,9 @@
 		fl = IT_LIGHTNING;
 		if (self.ammo_cells < 1)
 			am = 1;
-	}
+        }
 
-	self.impulse = 0;
+        self.impulse = 0;
 	
 	if (!(self.items & fl))
 	{	// don't have the weapon or the ammo
@@ -1041,7 +1198,8 @@
 		IT_SUPER_NAILGUN |
 		IT_GRENADE_LAUNCHER |
 		IT_ROCKET_LAUNCHER |
-		IT_KEY1 | IT_KEY2;
+                IT_EXTRA_WEAPON |
+                IT_KEY1 | IT_KEY2;
 
 	self.ammo_cells = 200;
 	self.items = self.items | IT_LIGHTNING;
@@ -1105,10 +1263,16 @@
 		}
 		else if (self.weapon == IT_GRENADE_LAUNCHER)
 		{
+                        self.weapon = IT_EXTRA_WEAPON;
+                        if (self.ammo_shells < 3)
+				am = 1;
+                }
+                else if (self.weapon == IT_EXTRA_WEAPON)
+		{
 			self.weapon = IT_ROCKET_LAUNCHER;
 			if (self.ammo_rockets < 1)
 				am = 1;
-		}
+                }
 		else if (self.weapon == IT_ROCKET_LAUNCHER)
 		{
 			self.weapon = IT_LIGHTNING;
@@ -1151,10 +1315,17 @@
 		}
 		else if (self.weapon == IT_ROCKET_LAUNCHER)
 		{
+                        self.weapon = IT_EXTRA_WEAPON;
+                        if (self.ammo_shells < 3)
+				am = 1;
+		}
+                else if (self.weapon == IT_EXTRA_WEAPON)
+		{
 			self.weapon = IT_GRENADE_LAUNCHER;
 			if (self.ammo_rockets < 1)
 				am = 1;
 		}
+
 		else if (self.weapon == IT_GRENADE_LAUNCHER)
 		{
 			self.weapon = IT_SUPER_NAILGUN;
