/*
=====================
Grenade Launcher Grenade

Pops up, rotates and fires nails before exploding.
Code is from TeamFortress 1.0 by Robin Walker, John Cook and Ian Caughley.
=====================
*/
void() NailLauncherTouch =
{
	if (other == self.owner)
		return;		// don't explode on owner

	// If the Nail Grenade hits a player, it just bounces off

	sound (self, CHAN_WEAPON, "weapons/bounce.wav", 1, ATTN_NORM);
	if (self.velocity == '0 0 0')
		self.avelocity = '0 0 0';
};

void() NailLauncherLaunchNail =
// Fire three nails in random directions, parallel to the ground
{
	local float i,j;

	i = 0;
	while (i < 3)
	{
		j = (random() + 2) * 2;
		current_yaw = anglemod( self.angles_y );
		current_yaw = anglemod(current_yaw + j);
		self.angles_y = current_yaw;
		self.angles_x = 0;
		self.angles_z = 0;
		makevectors(self.angles);

		launch_spike(self.origin, v_forward);

		i = i + 1;
	}

	self.nextthink = time + 0.1;

	// Explode?
        if (random() < 0.01)
		self.think = GrenadeExplode;
};

void() NailLauncherNailEm =
// Ready to launch nails
{
	// Rotate and spew Nails
	self.velocity = '0 0 0';

	self.nextthink = time + 0.1;
	self.think = NailLauncherLaunchNail;
};

void() NailLauncherExplode =
// Pop up and launch nails
{
	// Raise into the air
	self.movetype = MOVETYPE_NOCLIP;
	self.velocity = '0 0 100';
	self.avelocity = '0 500 0';
	self.nextthink = time + 0.5;
	self.think = NailLauncherNailEm;
};

void() W_FireNailLauncher =
{
	local	entity missile, mpuff;

	sound (self, CHAN_WEAPON, "weapons/grenade.wav", 1, ATTN_NORM);

	self.punchangle_x = -2;

	missile = spawn ();
	missile.owner = self;
	missile.movetype = MOVETYPE_BOUNCE;
	missile.solid = SOLID_BBOX;
	missile.classname = "grenade";
        missile.nextthink = time + 2 + 5*random();

	makevectors (self.v_angle);

	if (self.v_angle_x)
		missile.velocity = v_forward*600 + v_up * 200 + crandom()*v_right*10 + crandom()*v_up*10;
	else
	{
		missile.velocity = aim(self, 10000);
		missile.velocity = missile.velocity * 600;
		missile.velocity_z = 200;
	}

	missile.avelocity = '300 300 300';

	missile.angles = vectoangles(missile.velocity);

	missile.touch = NailLauncherTouch;
        missile.think = NailLauncherExplode;

        self.currentammo = self.ammo_rockets = self.ammo_rockets - 1;

	setmodel (missile, "progs/grenade.mdl");
	setsize (missile, '0 0 0', '0 0 0');
	setorigin (missile, self.origin);
};

//========================================================
//========================================================

/*
=====================
Homer Launcher Grenade

Pops up, rotates and fires homers before exploding.
Code is from TeamFortress 1.0 by Robin Walker, John Cook and Ian Caughley.
only this one fires homing missiles instead of nails, a devastating effect,
to your enemy's
=====================
*/
void() HomeLauncherTouch =
{
	if (other == self.owner)
		return;		// don't explode on owner

        // If the Home Launcher Grenade hits a player, it just bounces off

	sound (self, CHAN_WEAPON, "weapons/bounce.wav", 1, ATTN_NORM);
	if (self.velocity == '0 0 0')
		self.avelocity = '0 0 0';
};

void() HomeLauncherLaunchHomer =
// Fire three homers in random directions, parallel to the ground
{
	local float i,j;

	i = 0;
	while (i < 3)
	{
		j = (random() + 2) * 2;
		current_yaw = anglemod( self.angles_y );
		current_yaw = anglemod(current_yaw + j);
		self.angles_y = current_yaw;
		self.angles_x = 0;
		self.angles_z = 0;
		makevectors(self.angles);

                W_FireHomingMissile; 
                setorigin (missile, self.origin + v_forward*8 + '0 0 16');

                //launch_spike(self.origin, v_forward);

		i = i + 1;
	}

	self.nextthink = time + 0.1;

	// Explode?
        if (random() < 0.01)
		self.think = GrenadeExplode;
};

void() HomeLauncherHomeEm =
// Ready to launch homers
{
        // Rotate and spew Homers
	self.velocity = '0 0 0';

	self.nextthink = time + 0.1;
        self.think = HomeLauncherLaunchHomer;
};

void() HomeLauncherExplode =
// Pop up and launch homers
{
	// Raise into the air
	self.movetype = MOVETYPE_NOCLIP;
	self.velocity = '0 0 100';
	self.avelocity = '0 500 0';
	self.nextthink = time + 0.5;
        self.think = HomeLauncherHomeEm;
};

void() W_FireHomeLauncher =
{
	local	entity missile, mpuff;

	sound (self, CHAN_WEAPON, "weapons/grenade.wav", 1, ATTN_NORM);

	self.punchangle_x = -2;

	missile = spawn ();
	missile.owner = self;
	missile.movetype = MOVETYPE_BOUNCE;
	missile.solid = SOLID_BBOX;
	missile.classname = "grenade";
        missile.nextthink = time + 2 + 5*random();

	makevectors (self.v_angle);

	if (self.v_angle_x)
		missile.velocity = v_forward*600 + v_up * 200 + crandom()*v_right*10 + crandom()*v_up*10;
	else
	{
		missile.velocity = aim(self, 10000);
		missile.velocity = missile.velocity * 600;
		missile.velocity_z = 200;
	}

	missile.avelocity = '300 300 300';

	missile.angles = vectoangles(missile.velocity);

        missile.touch = HomeLauncherTouch;
        missile.think = HomeLauncherExplode;

        self.currentammo = self.ammo_rockets = self.ammo_rockets - 50;

	setmodel (missile, "progs/grenade.mdl");
	setsize (missile, '0 0 0', '0 0 0');
	setorigin (missile, self.origin);
};

