@echo off
echo  *************************************
echo *** QuakeMap Batch for DOS run-time ***
echo  *************************************
echo.

rem ***  Quake root directory is set here : ***
set QUAKE=\QUAKE
set TOOLDIR=.

if "%1"=="" goto Info
if "%QUAKE%"=="" goto OutOfEnv
if "%TOOLDIR%"=="" goto OutOfEnv

if exist qmdosrt~.bat del qmdosrt~.bat

:Loop
if "%1"=="" goto Stop
if "%1"=="/b" goto Rebuild
if "%1"=="/m" goto Macro
if "%1"=="/q" goto Run
if "%1"=="/t" goto TestBsp
if "%1"=="/stop" goto Stop
goto RT

:Rebuild
shift
cd %QUAKE%\QMapExec
if not exist %TOOLDIR%\QBSP.EXE goto BuildError
if not exist %TOOLDIR%\VIS.EXE goto BuildError
if not exist %TOOLDIR%\LIGHT.EXE goto BuildError
del maps\%1.bsp
%TOOLDIR%\QBSP maps/%1
if not exist maps\%1.bsp goto QBSPError
%TOOLDIR%\VIS maps/%1
%TOOLDIR%\LIGHT -extra maps/%1
shift
goto Loop

:Macro
shift
cd %QUAKE%\QMapExec
if not exist %TOOLDIR%\QBSP.EXE goto BuildError
if not exist %TOOLDIR%\VIS.EXE goto BuildError
if not exist %TOOLDIR%\LIGHT.EXE goto BuildError
rem {
echo This text should not appear on your screen.
rem }
shift
goto Loop

:QBSPError
echo.
echo -----------------------------------------------------------------------------
echo QBSP failed.  Press any key to continue...
pause > nul
goto Stop

:BuildError
echo.
echo Build error : one of the following files do not exist :
echo.
echo  %TOOLDIR%\QBSP.EXE
echo  %TOOLDIR%\VIS.EXE
echo  %TOOLDIR%\LIGHT.EXE
echo.
echo These three files are required to build levels. They can be found at
echo any Quake-related ftp server (including ftp.cdrom.com/pub/idgames2).
echo.
pause
goto Stop

:RunTestBsp
if exist %QUAKE%\QMapExec\maps\%3.bsp del %QUAKE%\QMapExec\maps\%3.bsp
ren %QUAKE%\QMapExec\maps\%3 *.bsp

:Run
cd %QUAKE%
if not exist QMapExec\*.* md QMapExec
echo exec default.cfg > QMapExec\quake.rc
echo exec config.cfg >> QMapExec\quake.rc
echo exec autoexec.cfg >> QMapExec\quake.rc
echo exec qmapexec.cfg >> QMapExec\quake.rc
echo stuffcmds >> QMapExec\quake.rc
if exist QMapExec\config.cfg del QMapExec\config.cfg

Quake -game QMapExec %2 %3 %4 %5 %6 %7 %8 %9

goto Stop

:TestBsp
if "%2"=="+map" goto RunTestBsp
if not exist %QUAKE%\QMapExec\*.* md %QUAKE%\QMapExec
if not exist %QUAKE%\QMapExec\maps\*.* md %QUAKE%\QMapExec\maps
copy %2 %QUAKE%\QMapExec\maps\*.
cd %QUAKE%\QMapExec\maps
for %%a in (*.) do %0 /t +map %%a
echo Failed to run %2.
goto Stop

:Info
if exist qmdosrt.exe goto InfoRT
echo This batch has two purposes : it is used internally by QuakeMap
echo and it is used to launch the DOS Run-Time version of QuakeMap.
echo.
echo If you are using the full Windows version of QuakeMap, you don't
echo need to run this batch directly. If you want to use the DOS
echo Run-Time, QMDOSRT.EXE, you must put it in the current directory
echo first, and run QM.BAT then.
goto Stop

:InfoRT
echo This batch is used to extract and run a QuakeMap file.
echo It extracts maps, compiles QuakeC patches, uses QBSP to
echo reduild maps, and launches Quake.
echo.
echo Syntax :  QM [filename] [filename...]
echo  where [filename] is (are) the name of the '.qme' file(s).
echo.
goto Stop

:OutOfEnv
echo There is either a problem with your configuration, or you got an
echo "Out of environment space" error. If it is the case, then you
echo need to increase your environment space. In your file C:\CONFIG.SYS
echo look for a line like "shell=c:\command.com c:\ /e:1536 /p". If there is none,
echo add the line written above. If there is one, but there is no "/e:xxxx"
echo parameter, add "/e:1536". If this doesn't do, increase the number found
echo after "/e:".
pause
goto Stop

:RT
echo qmdosrt %1 %2 %3 %4 %5 %6 %7 %8 %9 > qmdosrt~.bat
qmdosrt~

:Stop
set TOOLDIR=
set QUAKE=
